#include "defs.h"

#include "load_symbols.h"
#include "matrix.h"
#include "dirty_filter.h"
#include "rotate.h"

#include <math.h>
#include <time.h>

#ifdef MYOWN_DEBUG_MALLOC
int malloc_count=0;
unsigned long malloced_space_in_bytes=0;
unsigned long malloced_space_in_bytes_peak=0;
#endif

/* program-wide global variables definitions set by command line with defaults */
bool verbmode=FALSE;
bool quietmode=FALSE;



void malloc_and_noisify(matrix *R,matrix *M,double sigma)
{
  int i,j,range;
  double z,normalization;
  matrix Q;

#define BORDER 10
#define LITTLE 0.05
  
  range=0;
  do range++; while (exp(-1.0*range*range/sigma/sigma)>LITTLE);

  normalization=0;
  for (i=-range+1;i<range;i++)
    normalization+=exp(-1.0*(i*i)/sigma/sigma);

  matrix_malloc(&Q,M->h+2*BORDER,M->w+2*BORDER);
  matrix_malloc(R,M->h+2*BORDER,M->w+2*BORDER);

  for (i=0;i<M->h;i++)
    for (j=0;j<M->w;j++)
      { 
	int u;
	u=M->lines[i][j];
	u+=rand()%61-30;
	M->lines[i][j]=(u>255)?255:((u<0)?0:u);
      }

  for (i=0;i<Q.h;i++)
    for (j=0;j<Q.w;j++)
      {
	int ii;

	z=0;
	for (ii=-range+1;ii<range;ii++)
	  z+=exp(-1.0*ii*ii/sigma/sigma)/normalization
	    *matrix_secure_get(M,i-BORDER+ii,j-BORDER);
	Q.lines[i][j]=z;
      }

  for (i=0;i<R->h;i++)
    for (j=0;j<R->w;j++)
      {
	int jj;

	z=0;
	for (jj=-range+1;jj<range;jj++)
	  z+=exp(-1.0*jj*jj/sigma/sigma)/normalization
	    *matrix_secure_get(&Q,i,j+jj);
	    R->lines[i][j]=z;
      }

  matrix_free(&Q);
}

int main(int argc,char **argv)
{
  tos S;
  int n;
  char *nametex;
  char *buffer;
  FILE *ftex;
  double rotation;
  matrix M,R;

  srand((int)time(NULL));

  load_symbols(argv[1],&S);
  sscanf(argv[3],"%d",&n);

  /* create tex file */
  MYOWN_ASPRINTF(&nametex,"%s.tex",argv[2]);
  ftex=fopen(nametex,"w");
  MYOWN_FREE(nametex,char,STRSIZE(nametex));
  
  fprintf(ftex,"\\font\\times=ptmr\n");
  fprintf(ftex,"\\times\n");
  fprintf(ftex,"\\nopagenumbers\\noindent\n");
  switch (S.table[n].representation[0])
    {
    case 'i': /* this is a hack for times: no dotless i... neither j */
      fprintf(ftex,"{\\rm\\i}");
      break;
    case 'j': 
      fprintf(ftex,"{\\rm\\j}");
      break;
    default:
      fprintf(ftex,"%s",S.table[n].representation);
      break;
    }
  fprintf(ftex," o n o n o n o n o\\bye\n");

  fclose(ftex);

  free_symbols(&S);

  /* create dvi */
  MYOWN_ASPRINTF(&buffer,"tex %s >/dev/null 2>/dev/null",argv[2]);
  system(buffer);
  MYOWN_FREE(buffer,char,STRSIZE(buffer));

  /* create pnm */
  MYOWN_ASPRINTF(&buffer,"dvips -q -f <%s.dvi |gs -sDEVICE=pgmraw -r300 -sGreyValues=256 -dTextAlphaBits=4 -q -dNOPAUSE -dSAFER -sOutputFile=- - -c quit |pnmcrop >%s.pnm 2>/dev/null",argv[2],argv[2]);
  system(buffer);
  MYOWN_FREE(buffer,char,STRSIZE(buffer));
  
  /* rotate and noisify it */
  rotation=(double)(rand()%GRANY)/GRANY;
  rotation=0.2*rotation-0.1;
  pnm_load(argv[2],&M);
  rotate_malloc_and_compute(rotation,&R,&M);
  matrix_free(&M);
  malloc_and_noisify(&M,&R,(double)(rand()%GRANY)/GRANY*2+1);
  matrix_free(&R);
  pnm_save(argv[2],&M);
  matrix_free(&M);

  printf("%f\n",-rotation);

  MYOWN_STATUS();

  return 0;
}
