#include "defs.h"

#include "path.h"
#include "numerical_classifiers.h"
#include "categorical_classifiers.h"
#include "tree.h"
#include "load_symbols.h"

#ifdef MYOWN_DEBUG_MALLOC
int malloc_count=0;
unsigned long malloced_space_in_bytes=0;
unsigned long malloced_space_in_bytes_peak=0;
#endif

/* program-wide global variables definitions set by command line with defaults */
bool verbmode=TRUE;
bool quietmode=FALSE;

void decision_compared(tos *S,tree_compared *T)
{
  char *buffer;
  int i,whiteindex;
  double numericals[nNC];
  int categoricals[nCC];
  
  while (TRUE)
  {
    MYOWN_GETLINE(&buffer,stdin);
    if (feof(stdin)) goto over;

    switch (buffer[0]) 
      {
      case '%':
	break;
      case '#':
	printf("\n%s",buffer);
	break;
      case 'S':
	printf(" ");
	break;
      default:
	whiteindex=0;
	for (i=0;i<nNC;i++)
	  {
	    sscanf(buffer+whiteindex,"%lf",numericals+i);
	    do whiteindex++; while (buffer[whiteindex]!=' ');
	  }
	for (i=0;i<nCC;i++)
	  {
	    sscanf(buffer+whiteindex,"%d\n",categoricals+i);
	    do whiteindex++; while (buffer[whiteindex]!=' ');
	  }
	
	printf("%s",S->table[tree_compared_decide(T,numericals,categoricals)].representation);
	break; 
      }

    MYOWN_FREE(buffer,char,STRSIZE(buffer));
  }
 over:
  MYOWN_FREE(buffer,char,STRSIZE(buffer));
  
  printf("\n");
}

int main(int argc,char **argv)
{
  tree_compared *T;
  tos S;
  
  load_symbols(argv[1],&S);
  T=tree_compared_fill(argv[2]);
  decision_compared(&S,T);
  tree_compared_complete_free(T);
  free_symbols(&S);

  MYOWN_STATUS();

  return 0;
}
