#define _GNU_SOURCE
/* we define this to use: getline, asprintf w/o warning 
   comparison_fn_t is a GNU extension */

#define MYOWN_DEBUG_MALLOC

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define VERSION "alpha 0.5 (Jan 15, 1999)"

/* granularity of random numbers 
   i don't remember the rule for big constants */
#define GRANY 27027503

typedef unsigned char graylevel;
#define FULLBLACK 0
#define FULLWHITE 255

/* inspired from curses.h */
typedef unsigned char bool;
#define TRUE (bool)1
#define FALSE (bool)0

/* program-wide global variables declarations set by command line */
extern bool verbmode;
extern bool quietmode;
extern bool info_and_quit;
extern bool guess;
extern double given_angle;
extern bool rotate;
extern bool save_rotated;
extern bool save_skeleton;
extern bool save_xetresult;
extern bool dump_paths;
extern int cutlevel;
extern double available_megabytes;
extern char *scanned_image_basename;

/* Macros with Variable Numbers of Arguments are a GNU extension */
#define VERBMESSAGE( rest... ) \
{ if (verbmode) { fprintf(stderr , ## rest ); fflush(stderr); } }
#define MESSAGE( rest... ) \
{ if (!quietmode) { fprintf(stderr , ## rest ); fflush(stderr); } }
#define FATALMESSAGE( rest... ) \
{ fprintf(stderr,"Error: "); fprintf(stderr , ## rest ); \
  fprintf(stderr,". Try `quinefaut --help' for more information\n"); fflush(stderr); exit(1); }

#define STRSIZE( s ) (1+strlen(s))

/* additional malloc debugging facilities */

#ifdef MYOWN_DEBUG_MALLOC

extern int malloc_count;
extern unsigned long malloced_space_in_bytes;
extern unsigned long malloced_space_in_bytes_peak;
#define MYOWN_MALLOC( a , type , size ) \
{ a = ( type *)malloc( size*sizeof(type) ); \
  malloc_count++; \
  malloced_space_in_bytes+= size*sizeof(type); \
  if (malloced_space_in_bytes>malloced_space_in_bytes_peak) \
   malloced_space_in_bytes_peak=malloced_space_in_bytes; } 
#define MYOWN_REALLOC( a , type , oldsize , newsize ) \
{ a = ( type *)realloc( a , newsize*sizeof(type) ); \
  malloced_space_in_bytes+= (newsize-oldsize)*sizeof(type); \
  if (malloced_space_in_bytes>malloced_space_in_bytes_peak) \
   malloced_space_in_bytes_peak=malloced_space_in_bytes; } 
#define MYOWN_FREE( a , type , size ) \
{ malloc_count--; malloced_space_in_bytes-=size*sizeof(type); free( a ); }
#define MYOWN_STATUS() \
{ VERBMESSAGE(" [%d (%ld) (peak %ld) malloc'ed]\n", \
  malloc_count,malloced_space_in_bytes,malloced_space_in_bytes_peak); }
#define MYOWN_ASPRINTF( buf , rest... ) \
{ asprintf( buf , ## rest ); \
  malloc_count++; \
  malloced_space_in_bytes+= STRSIZE( *( buf ) ); \
  if (malloced_space_in_bytes>malloced_space_in_bytes_peak) \
   malloced_space_in_bytes_peak=malloced_space_in_bytes; } 
#define MYOWN_GETLINE( buf , f ) \
{ int size=0; \
  *(buf)=NULL; \
  getline( buf , &size , f ); \
  malloc_count++; \
  malloced_space_in_bytes+= STRSIZE( *(buf) ); \
  if (malloced_space_in_bytes>malloced_space_in_bytes_peak) \
   malloced_space_in_bytes_peak=malloced_space_in_bytes; } 

#else

#define MYOWN_MALLOC( a , type , size ) \
  a = ( type *)malloc( size*sizeof(type) )
#define MYOWN_REALLOC( a , type , oldsize , newsize ) \
  a = ( type *)realloc( a , newsize*sizeof(type) ); 
#define MYOWN_FREE( a , type , size ) \
  free( a )
#define MYOWN_STATUS() \
  VERBMESSAGE("[MYOWN_DEBUG_MALLOC not activated]\n")
#define MYOWN_ASPRINTF( buf , rest... ) \
  asprintf( buf , ## rest ) 
#define MYOWN_GETLINE( buf , rest... ) \
  getline( buf , ## rest )

#endif

/* a reasonable size for an array-I-begin-to-fill-but-I-dont-know-
   -the-final-size. Must be realloc'ed if overflow */
#define SMALLARRAY 100

#define PLUSPLUSANDCTRL( index , array , type , floatingboundary ) \
{ index++; \
  if (index>=floatingboundary) \
    { MYOWN_REALLOC(array,type,floatingboundary,2*floatingboundary); \
      floatingboundary*=2; \
    } }

#define DECLARE_UNINITIALIZED(type,a) type a = (type)0

/* fatal error messages */
#define ERROR_WRONGOPT "Malformed command line option"
#define ERROR_NOFILE   "Provide a scanned image name"
#define ERROR_OPEN     "Opening read only file failed"
#define ERROR_NEWFILE  "Opening new file for writing failed"
#define ERROR_NOLINES  "Cannot find determine lines on the image"
