/* this is a quick-and-dirty filter to load and save raw grayscale pnm file
   if the file doesn't exist to load,
   if it's not pnm,
   if it's not grayscale,
   if it's not raw,
   the filter crashes. You are warned */

#include "defs.h"

#include "matrix.h"

void pnm_load(char *s,matrix *M)
{
  FILE *f;

  char *buffer;

  int i;
  
  MYOWN_ASPRINTF(&buffer,"%s.pnm",s);
  f=fopen(buffer,"r");
  MYOWN_FREE(buffer,char,STRSIZE(buffer));
  if (!f) FATALMESSAGE(ERROR_OPEN);

  /* skip first line (P5) */
  MYOWN_GETLINE(&buffer,f);

  /* skip comments lines */
  do
    {
      MYOWN_FREE(buffer,char,STRSIZE(buffer));
      MYOWN_GETLINE(&buffer,f);
    }
  while (buffer[0]=='#');
      
  /* read width height data */
  sscanf(buffer,"%d %d",&M->w,&M->h);
  MYOWN_FREE(buffer,char,STRSIZE(buffer));

  /* skip line (255) */
  MYOWN_GETLINE(&buffer,f);
  MYOWN_FREE(buffer,char,STRSIZE(buffer));

  matrix_malloc(M,M->h,M->w);

  for (i=0;i<M->h;i++)
	fread(M->lines[i],1,M->w,f);

  VERBMESSAGE(" loading PNM over\n");

  fclose(f);
}

void pnm_save(char *s,matrix *M)
{
  FILE *f;
  char *buffer;
  int i;

  MYOWN_ASPRINTF(&buffer,"%s.pnm",s);
  f=fopen(buffer,"w");
  MYOWN_FREE(buffer,char,STRSIZE(buffer));
  if (!f) FATALMESSAGE(ERROR_NEWFILE);
  
  fprintf(f,"P5\n");
  fprintf(f,"# CREATOR: The quinefaut's dirty PNM Filter\n");
  fprintf(f,"%d %d\n",M->w,M->h);
  fprintf(f,"255\n");

  for (i=0;i<M->h;i++)
    fwrite(M->lines[i],1,M->w,f);

  VERBMESSAGE(" saving PNM over\n");

  fclose(f);
}



