#include "defs.h"

#include "load_symbols.h"

void load_symbols(char *basename,tos *S)
{				
  char *buffer;
  FILE *f;
  int i,pos;

  MYOWN_ASPRINTF(&buffer,"%s.symbols",basename);
  f=fopen(buffer,"r");
  MYOWN_FREE(buffer,char,STRSIZE(buffer));

  MYOWN_GETLINE(&buffer,f);
  sscanf(buffer,"# %d",&S->size);
  MYOWN_MALLOC(S->table,symbol,S->size);

  for (i=0;i<S->size;i++)
    {
      MYOWN_FREE(buffer,char,STRSIZE(buffer));
      MYOWN_GETLINE(&buffer,f);
      
      sscanf(buffer,"%lf",&S->table[i].frequency);
      pos=0;
      while (buffer[pos]!=' ') pos++;
      pos++;
      MYOWN_MALLOC(S->table[i].representation,char,strlen(buffer)-pos);
      strncpy(S->table[i].representation,buffer+pos,strlen(buffer)-pos-1);
      S->table[i].representation[strlen(buffer)-pos-1]='\0';
    }
  MYOWN_FREE(buffer,char,STRSIZE(buffer));
  
  fclose(f);
}

void free_symbols(tos *S)
{
  int i;
  for (i=0;i<S->size;i++)
    MYOWN_FREE(S->table[i].representation,char,
	       STRSIZE(S->table[i].representation));
  MYOWN_FREE(S->table,symbol,S->size);
}





