#include "defs.h"

#include "matrix.h"

void matrix_malloc(matrix *M,int h,int w)
{ 
  int i;

  VERBMESSAGE(" allocating %dx%d matrix (%.1f Mb)\n",(int)h,(int)w,1e-6*h*w*sizeof(graylevel));

  M->h=h;
  M->w=w; 
  MYOWN_MALLOC(M->lines,matrix_line,h);
  for (i=0;i<h;i++) MYOWN_MALLOC(M->lines[i],graylevel,w);
}

void matrix_free(matrix *M)
{
  int i;

  VERBMESSAGE(" freeing %dx%d matrix\n",(int)M->h,(int)M->w);

  for (i=0;i<M->h;i++) MYOWN_FREE(M->lines[i],graylevel,M->w);
  MYOWN_FREE(M->lines,matrix_line,M->h);
}

void matrix_fill_line(matrix *M,int i,graylevel *line)
{
  memcpy(M->lines[i],line,M->w*sizeof(graylevel));
}

graylevel matrix_secure_get(matrix *M,int i,int j)
{
  /* if coordinates seek out of the matrix return white.
     i tried this written as a macro, not faster, it seems gcc makes
     the optimisation itself. */
  if ((0<=i)&&(i<M->h)&&(0<=j)&&(j<M->w)) 
    return M->lines[i][j];
  else 
    return FULLWHITE;
}
