/* compute the min, max, and other trivial functions over the matrix */
/* three values can be used to tell if a pixel is black or white:
   (min+max)/2
   average
   ``mediane'' (half of the repartition function) */


#include "defs.h"

#include "matrix.h"
#include "minimax.h"

graylevel min(matrix *M)
{
  int i,j;
  graylevel x,m=FULLWHITE;
  
  for (i=0;i<M->h;i++)
    for (j=0;j<M->w;j++)
      {
	x=M->lines[i][j];
	if (x<m) m=x;
      }
  return m;
}

graylevel max(matrix *M)
{
  int i,j;
  graylevel x,m=0;
  
  for (i=0;i<M->h;i++)
    for (j=0;j<M->w;j++)
      {
	x=M->lines[i][j];
	if (x>m) m=x;
      }
  return m;
}

double average(matrix *M)
{
  int i,j;
  double u=0;
   
  for (i=0;i<M->h;i++)
    for (j=0;j<M->w;j++)
	u+=M->lines[i][j];

  return u/M->h/M->w;
}

/* what's the english word for mediane? */
graylevel mediane(matrix *M)
{
  int i,j,k;
  double rep[FULLWHITE+1],midrep;
  
  /* assuming that FULLWHITE+1 fits in an int! */
  for (k=0;k<FULLWHITE+1;k++) rep[k]=0;

  for (i=0;i<M->h;i++)
    for (j=0;j<M->w;j++)
    rep[M->lines[i][j]]++;
 
  k=0;
  midrep=0;
  while (2.0*midrep<(double)M->h*M->w) 
    {
      midrep+=rep[k];
      k++;
    }
  k--;
  
  return (graylevel)k;
}





