#include "defs.h"

#include "path.h"
#include "numerical_classifiers.h"

#include <math.h>

/* here is the table of pertinent numerical classifiers
   i would like them to be font independent, scaling independent.
   can be rotation dependent */
numerical_classifier NC[] =
        {
	  { scale, "SCALE" },
          { tallness, "TALLNESS" },
	  { spaghettiness, "SPAGHETTINESS" },
	  { blackness, "BLACKNESS" },
	  { bottomness, "BOTTOMNESS" },
	  { rightness, "RIGHTNESS" }
        };
int nNC = sizeof(NC)/sizeof(NC[0]);

NUMERICAL_CLASSIFIER(scale)
{
  return (P->bottom-P->top)/(baseline-xline);
}

NUMERICAL_CLASSIFIER(tallness)
{
  return (P->bottom-P->top)/(P->right-P->left);
}

static double length(path *P);

NUMERICAL_CLASSIFIER(spaghettiness)
{
  double L;
  lop *holes;
  
  L=length(P);
  for (holes=P->holes;holes;holes=holes->next) L+=length(&holes->data);
  
  return 1-M_PI*4*P->area/L/L;
}

NUMERICAL_CLASSIFIER(blackness)
{
  return P->area/(P->bottom-P->top)/(P->right-P->left);
}

NUMERICAL_CLASSIFIER(bottomness)
{
  return (P->xg-(P->top+P->bottom)/2)/(P->bottom-P->top);
}

NUMERICAL_CLASSIFIER(rightness)
{
  return (P->yg-(P->left+P->right)/2)/(P->right-P->left);
}

double length(path *P)
{
  pair *u,*pu;
  double x1,y1,x2,y2,l=0;
  DECLARE_UNINITIALIZED(double,firstx);
  DECLARE_UNINITIALIZED(double,firsty);

  pu=NULL;
  for (u=P->first;u;u=u->next)
    {
      if (pu)
	{
	  x1=pu->x;
	  x2=u->x;
	  y1=pu->y;
	  y2=u->y;
	  l+=sqrt((x2-x1)*(x2-x1)+(y2-y1)*(y2-y1));
	}
      else
	{
	  firstx=u->x;
	  firsty=u->y;
	}
      pu=u;
    }
  x1=pu->x;
  x2=firstx;
  y1=pu->y;
  y2=firsty;
  l+=sqrt((x2-x1)*(x2-x1)+(y2-y1)*(y2-y1));
  
  return l;
}
