#include "defs.h"

#include "path.h"

void path_init(path *P)
{
  P->first=NULL;
  P->last=NULL; 
  P->length=0;
  P->closed=FALSE;
  /* the next line is for security purpose */
  P->holes=NULL;
}

void path_add_before_first(path *P,double x,double y)
{
  pair *new;

  MYOWN_MALLOC(new,pair,1);
  new->x=x;
  new->y=y;
  new->next=P->first;
  P->first=new;
  if (!P->last) P->last=P->first;
  P->length++;
}

void path_add_after_last(path *P,double x,double y)
{
  if (P->last)
    {
      pair *new;
      
      MYOWN_MALLOC(new,pair,1);
      new->x=x;
      new->y=y;
      new->next=NULL;
      (P->last)->next=new;
      P->last=new;
      P->length++;
    }
  else
      path_add_before_first(P,x,y);
}

/* this function puts P1 at the beginning of P2, building an extension of P2.
   since P1->last and P2->first are approx (SAMEPOINT)
   the same, P1->last is kept and P2->first freed. P1 is *not* freed. DIY */
void path_assemble(path *P1,path *P2)
{
  P1->last->next=P2->first->next;
  P2->length+=P1->length-1;
  MYOWN_FREE(P2->first,pair,1);
  P2->first=P1->first;
}

void path_free(path *P)
{
  pair *u,*v;
  
  u=P->first;
  while (u)
    {
      v=u;
      u=u->next;
      MYOWN_FREE(v,pair,1);
    }
}

/* ``gnuplotish'' because we insert after each written pair a string that
   can be grep'd to feed gnuplot and check the result, so useful */
void path_dump(path *P,char *gnuplotish,bool detailed,bool withholes)
{
  int i=0;
  pair *u;
  lop *U;
  char *gnuplotishholes;

  printf(" length=%d area=%.5f",P->length,P->area);
  if (P->closed) printf(" closed"); else printf(" not closed");
  printf(" [%.5f<%.5f<%.5f]x[%.5f<%.5f<%.5f]\n",
	 P->top,P->xg,P->bottom,
	 P->left,P->yg,P->right);
  
  if (detailed)
    for (u=P->first;u;u=u->next)
      printf(" %.9f %.9f %s\n",u->x,u->y,gnuplotish);

  if (withholes)
    {
      for (U=P->holes;U;U=U->next) 
	{
	  MYOWN_ASPRINTF(&gnuplotishholes,"%s hole%03d",gnuplotish,i);
	  path_dump(&U->data,gnuplotishholes,detailed,FALSE);
	  MYOWN_FREE(gnuplotishholes,char,STRSIZE(gnuplotishholes));
	  i++;
	}
      printf(" %d Holes\n",i);
    }
}

lop* lop_add(lop* L,path *P)
{
  lop *U;

  MYOWN_MALLOC(U,lop,1);
  U->data=*P;
  U->next=L;
  return U;
}

void lop_free(lop* L)
{
  lop *U,*V;

  U=L;
  while (U)
    {
      V=U;
      U=U->next;
      MYOWN_FREE(V,lop,1);
    }
}

void lop_dump(lop *L,char *comment,bool detailed)
{
  lop *U;
  int i=0;
  char *gnuplotish;

  for (U=L;U;U=U->next) 
    {
      MYOWN_ASPRINTF(&gnuplotish,"%s%03d",comment,i);
      printf("%s",gnuplotish);
      gnuplotish[0]+=0x20;
      path_dump(&U->data,gnuplotish,detailed,FALSE);
      MYOWN_FREE(gnuplotish,char,STRSIZE(gnuplotish));
      i++;
    }
}

void top_dump(top* T,char *comment,bool detailed,bool withholes)
{
  int i;
  char *gnuplotish;

  for (i=0;i<T->size;i++)
    {
      MYOWN_ASPRINTF(&gnuplotish,"%s%03d",comment,i);
      printf("%s",gnuplotish);
      gnuplotish[0]+=0x20;
      path_dump(&T->table[i],gnuplotish,detailed,withholes);
      MYOWN_FREE(gnuplotish,char,STRSIZE(gnuplotish));
    }
}

/* use this code to recursively completely free a top with affected holes */
void top_complete_free(top *T)
{
  int i;
  lop *L;

  for (i=0;i<T->size;i++) 
    {
      for (L=T->table[i].holes;L;L=L->next) path_free(&L->data);
      lop_free(T->table[i].holes);
      path_free(T->table+i);
    }
  MYOWN_FREE(T->table,path,T->size);
}
