/* pair is the elementary maillon of the chained list */

typedef struct _pair
{
  double x,y;
  struct _pair *next;
} pair;

/* beware, struct _path and struct _lop are mutually referent */

struct _path
{
  pair *first,*last;
  int length;
  double area;
  bool closed;
  double xg,yg;
  double left,right,top,bottom;
  struct _lop *holes;
};

struct _lop
{
  struct _path data;
  struct _lop *next;
};

typedef struct _path path;
typedef struct _lop lop;

typedef struct
{
  int size;
  path *table;
} top;

/* you may make lists of pairs using pair*, but use path type instead:
   we always need the first and last element to be accessible.

   As a counterpart, use lop* directly to build lists of paths. lop means
   List Of Paths. lop is a convenient type do store path when we do
   not know how much they are. If we do, prefer top... */

void path_init(path *P);
void path_add_before_first(path *P,double x,double y);
void path_add_after_last(path *P,double x,double y);
void path_assemble(path *P1,path *P2);
void path_free(path *P);
void path_dump(path *P,char *gnuplotish,bool detailed,bool withholes);

lop* lop_add(lop* L,path *P);
void lop_free(lop* L);
void lop_dump(lop* L,char *comment,bool detailed);

void top_dump(top* T,char *comment,bool detailed,bool withholes);
void top_complete_free(top *T);
