#include "defs.h"
#include "matrix.h"
#include "dirty_filter.h"
#include "minimax.h"
#include "correct_orientation.h"
#include "rotate.h"
#include "path.h"
#include "connexity.h"
#include "clui.h"
#include "xet.h"
#include "charax.h"
#include "skeleton.h"

#include <time.h>

#ifdef MYOWN_DEBUG_MALLOC
int malloc_count=0;
unsigned long malloced_space_in_bytes=0;
unsigned long malloced_space_in_bytes_peak=0;
#endif

int main(int argc,char **argv)
{
  matrix M,R;
  int seed;
  int z1,z2,z3;
  double alpha=0;
  top T;
  tol C;
 
  clui_understand(argc,argv);
  banner();

  seed=(int)time(NULL);
  srand(seed);
  VERBMESSAGE("Initializing RNG to %d - keep the value for bug report\n",seed);

  pnm_load(scanned_image_basename,&M);
  
  z1=(min(&M)+max(&M))/2;
  z2=average(&M);
  z3=mediane(&M);
  
  if (info_and_quit) 
    {
      printf("Information [ (z_min+z_max)/2=%d z_average=%d z_mediane=%d ]\n",z1,z2,z3);
      matrix_free(&M);
      MYOWN_FREE(scanned_image_basename,char,STRSIZE(scanned_image_basename));
      goto clean_exit;
    }
  else
      MESSAGE("Information [ (z_min+z_max)/2=%d z_average=%d z_mediane=%d ]\n",z1,z2,z3);

  if (cutlevel==-1) cutlevel=z1;
  if (cutlevel==-2) cutlevel=z2;
  if (cutlevel==-3) cutlevel=z3;

  MESSAGE("Cutting at z=%d\n",cutlevel);
  MESSAGE("\n");

  if (rotate)
    {
      if (guess)
	{
	  MESSAGE("Guessing orientation...\n");
	  alpha=guess_alpha(&M,cutlevel,-0.3,0.3);
	}
      else
	alpha=given_angle;
      
      MESSAGE("Rotating by %f rad...\n",alpha);
      rotate_malloc_and_compute(alpha,&R,&M);
      matrix_free(&M);

      if (save_rotated) 
	{
	  char *buffer;
	  
	  MYOWN_ASPRINTF(&buffer,"%s-rotated%frad",scanned_image_basename,alpha); 
	  pnm_save(buffer,&R);
	  MYOWN_FREE(buffer,char,STRSIZE(buffer));
	}
    }
  else
      R=M;
  
  MESSAGE("Finding connex components...\n");
  connexity_find_paths(&T,&R,cutlevel,available_megabytes);

  if (dump_paths)
    {
      top_dump(&T,"Path",TRUE,TRUE);   
      top_complete_free(&T);
      matrix_free(&R);
      MYOWN_FREE(scanned_image_basename,char,STRSIZE(scanned_image_basename));
      goto clean_exit;
    }

  if (save_skeleton) skeleton_from_top(scanned_image_basename,&R,&T);

  MESSAGE("Running XeT...\n");
  xet_makelines(&C,&T);

  if (save_xetresult) skeleton_xetresult(scanned_image_basename,&R,&T,&C);

  charax_dump(&T,&C);

  tol_complete_free(&C);
  top_complete_free(&T);
  matrix_free(&R);
  MYOWN_FREE(scanned_image_basename,char,STRSIZE(scanned_image_basename));

 clean_exit:
  MYOWN_STATUS();
  return 0;
}
