#include "defs.h"

#include "matrix.h"
#include "rotate.h"

#include <math.h>

double interpolate(matrix *M,double x,double y)
{
  int i,j;
  double p1,p2,q1,q2;
  double topleft,topright,bottomleft,bottomright;
  i=floor(x);
  j=floor(y);
  p1=x-i;
  p2=i+1-x;
  q1=y-j;
  q2=j+1-y;
  topleft    =matrix_secure_get(M,i  ,j);
  bottomleft =matrix_secure_get(M,i+1,j);
  topright   =matrix_secure_get(M,i  ,j+1);
  bottomright=matrix_secure_get(M,i+1,j+1);
  /* this is not a very good approx but should be fast (quadric surface)
     better use cubic splines! */
  /* beware, p1 is the weight of the topRIGHT point */
  return p2*(q2*topleft   +q1*topright)
        +p1*(q2*bottomleft+q1*bottomright);
}

void rotate_malloc_and_compute(double alpha,matrix *dest,matrix *source)
{
  double left,right,top,bottom;
  int i,j;
  double ca,sa,x,y;
  
  ca=cos(alpha);
  sa=sin(alpha);
  if (alpha>=0)
    {
      top=-(double)source->w*sa;
      bottom=(double)source->h*ca;
      left=0;
      right=(double)source->w*ca+(double)source->h*sa;
    }
  else
    {
      top=0;
      bottom=(double)source->h*ca-(double)source->w*sa;
      left=(double)source->h*sa;
      right=(double)source->w*ca;
    }
  matrix_malloc(dest,ceil(bottom-top),ceil(right-left));
  
  /* we assume the default rounding mode is nearest integer */
  for (i=0;i<dest->h;i++)
    for (j=0;j<dest->w;j++)
      {
	x=ca*(i+top)+sa*(j+left);
	y=ca*(j+left)-sa*(i+top);
	dest->lines[i][j]=rint(interpolate(source,x,y));
      }
}

