#include "defs.h"

#include "matrix.h"
#include "dirty_filter.h"
#include "path.h"
#include "xet.h"

#include "skeleton.h"

#include <math.h>

/* double coordinates, but we draw in a discrete matrix.
 rint() returns a double, beware the automagic typecast */
static void drawline(matrix *M,double x1,double y1,double x2,double y2)
{
  int i1,j1,i2,j2,i,j;
  i1=rint(x1);
  j1=rint(y1);
  i2=rint(x2);
  j2=rint(y2);

  if (abs(i2-i1)>abs(j2-j1))
    {  
      if (i1>i2)
	{
	  i=i1;
	  i1=i2;
	  i2=i; 
	  j=j1;
	  j1=j2;
	  j2=j;
	
	}
      for (i=i1;i<=i2;i++)
	{
	  j=rint(j1+(double)(j2-j1)/(i2-i1)*(i-i1));
	  M->lines[i][j]=FULLBLACK;
	}
    }
  else
    {
      if (j1>j2)
	{
	  j=j1;
	  j1=j2;
	  j2=j; 
	  i=i1;
	  i1=i2;
	  i2=i;
	}
      for (j=j1;j<=j2;j++)
	{
	  i=rint(i1+(double)(i2-i1)/(j2-j1)*(j-j1));
	  M->lines[i][j]=FULLBLACK;
	}
    }
}

void skeleton_from_top(char *basename,matrix *M,top *T)
{
  int i,j;
  lop *L;
  path *P;
  matrix S;
  char *fullname;
  
  matrix_malloc(&S,M->h,M->w);
  for (i=0;i<S.h;i++)
    for (j=0;j<S.w;j++) S.lines[i][j]=M->lines[i][j];

  for (i=0;i<T->size;i++)
    {
      P=&T->table[i];
      drawline(&S,P->top,P->left,
	       P->bottom,P->left);
      drawline(&S,P->top,P->right,
	       P->bottom,P->right);
      drawline(&S,P->top,P->left,
	       P->top,P->right);
      drawline(&S,P->bottom,P->left,
	       P->bottom,P->right);

      for (L=T->table[i].holes;L;L=L->next) 
	{
	  P=&L->data;
	  drawline(&S,P->top,P->left,
		   P->bottom,P->left);
	  drawline(&S,P->top,P->right,
		   P->bottom,P->right);
	  drawline(&S,P->top,P->left,
		   P->top,P->right);
	  drawline(&S,P->bottom,P->left,
		   P->bottom,P->right);
	  drawline(&S,P->top,P->left,
		   P->bottom,P->right);
	  drawline(&S,P->top,P->right,
		   P->bottom,P->left);
	}
    }

  MYOWN_ASPRINTF(&fullname,"%s-skeleton",basename);
  pnm_save(fullname,&S);
  MYOWN_FREE(fullname,char,STRSIZE(fullname));
  
  matrix_free(&S);
}

void skeleton_xetresult(char *basename,matrix *M,top *T,tol *C)
{
  int i,j;
  DECLARE_UNINITIALIZED(int,pi);
  matrix S;
  char *fullname;

  matrix_malloc(&S,M->h,M->w);

  for (i=0;i<S.h;i++)
    for (j=0;j<S.w;j++) S.lines[i][j]=M->lines[i][j];

  for (j=0;j<C->size;j++)
    {
      drawline(&S,rint(C->table[j].baseline),0,
	       rint(C->table[j].baseline),M->w-1);
      drawline(&S,rint(C->table[j].xline),0,
	       rint(C->table[j].xline),M->w-1);

      for (i=0;i<C->table[j].length;i++)
	{
	  if (i!=0) 
	      drawline(&S,
		       T->table[C->table[j].indices[pi]].xg,
		       T->table[C->table[j].indices[pi]].yg,
		       T->table[C->table[j].indices[i]].xg,
		       T->table[C->table[j].indices[i]].yg);
	  pi=i;
	}
    }

  MYOWN_ASPRINTF(&fullname,"%s-xetresult",basename);
  pnm_save(fullname,&S);
  MYOWN_FREE(fullname,char,STRSIZE(fullname));
  
  matrix_free(&S);
}
    
 
