#include "defs.h"

#include "path.h"
#include "numerical_classifiers.h"
#include "categorical_classifiers.h"
#include "tree.h"

#include <time.h>

/* this code is completely infamous. notice that the dump routine
produces tree that can be read with this one: */
tree_compared *tree_compared_recursive_fill(FILE *f)
{
  char *buffer;
  int i;
  tree_compared *T;
  int *leftsplits;
  int floatingboundary;
 
  MYOWN_MALLOC(T,tree_compared,1);

  MYOWN_GETLINE(&buffer,f);

  /* is this a description of a numerical classifier? */
  for (i=0;(i<nNC)&&(strncmp(buffer,NC[i].description,strlen(NC[i].description))!=0);i++); /* boolean shortcut! */
  if (i<nNC)
    {
      T->numerical_split=TRUE;
      T->numerical=i;
      
      /* read the split value, a double */
      MYOWN_FREE(buffer,char,STRSIZE(buffer));
      MYOWN_GETLINE(&buffer,f);
      sscanf(buffer,"%lf",&T->splitvalue);
      
      /* what follows is the left tree */
      T->left=tree_compared_recursive_fill(f);

      /* skip the repetition (two lines) */
      MYOWN_FREE(buffer,char,STRSIZE(buffer));
      MYOWN_GETLINE(&buffer,f);
      MYOWN_FREE(buffer,char,STRSIZE(buffer));
      MYOWN_GETLINE(&buffer,f);

      /* what follows is the right tree */
      T->right=tree_compared_recursive_fill(f);
    }
  else
    {
      /* is this a description of a categorical classifier? */
      for (i=0;(i<nCC)&&(strncmp(buffer,CC[i].description,strlen(CC[i].description))!=0);i++); /* boolean shortcut! */
      if (i<nCC)
	{
	  T->numerical_split=FALSE;
	  T->categorical=i;

	  /* read the categories that lead to the left */
	  floatingboundary=SMALLARRAY;
	  MYOWN_MALLOC(leftsplits,int,floatingboundary);
	  
	  i=0;
	  do
	    {
	      MYOWN_FREE(buffer,char,STRSIZE(buffer));
	      MYOWN_GETLINE(&buffer,f);
	      sscanf(buffer,"%d",leftsplits+i);
	      
	      /* incrementation and reallocation if needed */
	      PLUSPLUSANDCTRL(i,leftsplits,int,floatingboundary);
	    }
	  while (buffer[strlen(buffer)-2]==',');

	  MYOWN_REALLOC(leftsplits,int,floatingboundary,i);
	  T->leftsplits=leftsplits;
	  T->ncat=i;

	  /* what follows is the left tree */
	  T->left=tree_compared_recursive_fill(f);
	  
	  /* skip the categories that lead to the right (complementary) */
	  MYOWN_FREE(buffer,char,STRSIZE(buffer));
	  MYOWN_GETLINE(&buffer,f);
	  do
	    {
	      MYOWN_FREE(buffer,char,STRSIZE(buffer));
	      MYOWN_GETLINE(&buffer,f);
	    }
	  while (buffer[strlen(buffer)-2]==',');

	  /* what follows is the right tree */
	  T->right=tree_compared_recursive_fill(f);
	}
      else
	{
	  /* so, this is a terminal node */
	  sscanf(buffer,"%d",&T->decided);
	  T->left=NULL;
	}
    }

  MYOWN_FREE(buffer,char,STRSIZE(buffer));

  return T;
}

tree_compared *tree_compared_fill(char *questoutput)
{
  FILE *f;
  tree_compared *T;

  f=fopen(questoutput,"r");
  T=tree_compared_recursive_fill(f);
  fclose (f);

  return T;
}

void tree_compared_dump(tree_compared *T)
{
  if (T->left)
    {
      if (T->numerical_split)
	{
	  printf("%s\n",NC[T->numerical].description);
	  printf("%.4f\n",T->splitvalue);
	  tree_compared_dump(T->left);
	  printf("%s\n",NC[T->numerical].description);
	  printf("%.4f\n",T->splitvalue);
	  tree_compared_dump(T->right);
	}
      else
	{
	  int i;

	  printf("%s\n",CC[T->categorical].description);
	  for (i=0;i<T->ncat-1;i++) printf("%d,\n",T->leftsplits[i]);
	  printf("%d\n",T->leftsplits[i]);
	  tree_compared_dump(T->left);
	  printf("%s\n",CC[T->categorical].description);
	  for (i=0;i<T->ncat-1;i++) printf("%d,\n",T->leftsplits[i]);
	  printf("%d\n",T->leftsplits[i]);
	  tree_compared_dump(T->right);
	}
    }
  else
    printf("%d\n",T->decided);
}

void tree_compared_complete_free(tree_compared *T)
{
  if (T->left)
    {
      if (!T->numerical_split)
	MYOWN_FREE(T->leftsplits,int,T->ncat);
      
      tree_compared_complete_free(T->left);
      tree_compared_complete_free(T->right);
    }

  MYOWN_FREE(T,tree_compared,1);
}

int tree_compared_decide(tree_compared *T,double *numericals,int *categoricals)
{
  int i;
  
  while (T->left)
    {
      if (T->numerical_split)
	{
	  /*	  printf("comparing %f<%f\n",numericals[T->numerical],T->splitvalue);*/
	  if (numericals[T->numerical]<=T->splitvalue)
	    T=T->left;
	  else
	    T=T->right;
	}
      else
	{
	  /*	  printf("%d %d  comparing %d\n",(int)T->numerical_split,T->ncat,categoricals[T->categorical]);*/
	  for (i=0;i<T->ncat;i++) 
	    if (categoricals[T->categorical]==T->leftsplits[i]) break;
	  if (i<T->ncat)
	    T=T->left;
	  else
	    T=T->right;
	}
    }
  return T->decided;
}
