/* tex makes boxes into lines
   we too, but to perform the inverse action so I called it XeT 

   adapted for languages read from left to right, then up to down... */

#include "defs.h"

#include "path.h"
#include "matrix.h"
#include "correct_orientation.h"
#include "dirty_filter.h"
#include "accumulation.h"
#include "xet.h"

#include <math.h>

int compare_baselines (const line *a,const line *b)
{
  if (a->baseline>b->baseline)
    return 1;
  else
    if (a->baseline<b->baseline)
      return -1;
    else 
      return 0;
}

void xet_makelines(tol *C,top *T)
{
  int i,j,l,njunk;
  int junksize=SMALLARRAY,Csize=SMALLARRAY;
  double xg,yg,right,newbadness;
  int *previous,*next;
  double *badness;

/* at least ISALINE characters to consider as a line */
#define ISALINE 8
#define NONE -1

  MYOWN_MALLOC(previous,int,T->size);
  MYOWN_MALLOC(next,int,T->size);
  MYOWN_MALLOC(badness,double,T->size);

  for (i=0;i<T->size;i++)
    {
      previous[i]=NONE;
      next[i]=NONE;
      badness[i]=DBL_MAX;
    }

  /* absurd and false algorithm, nevertheless it works...?
     gives different results for differently sorted input arrays.
     MUST BE REIMPLEMENTED */
  for (i=0;i<T->size;i++)
    {
      xg=T->table[i].xg;
      yg=T->table[i].yg;
      right=T->table[i].right;

      for (j=0;j<T->size;j++)
	{
	  if (T->table[j].left<yg)
	    newbadness=DBL_MAX;
	  else
	    {
	      newbadness=fabs(T->table[j].left-right);
	      newbadness+=fabs(T->table[j].xg-xg)*3;
	    }

	  if (
	      (newbadness<badness[i])
	      &&((previous[j]!=NONE)?(newbadness<badness[previous[j]]):TRUE)
	      )
	    {
	      /* first, delete previous references */
	      if (next[i]!=NONE) previous[next[i]]=NONE;
	      if (previous[j]!=NONE) next[previous[j]]=NONE;

	      /* put new ones */
	      next[i]=j;
	      previous[j]=i;
	      badness[i]=newbadness;
	    }
	}
    }
  
  /* with a majorant of number of lines, to be realloc'd */
  MYOWN_MALLOC(C->table,line,Csize);
  MYOWN_MALLOC(C->table[0].indices,int,junksize);
  
  njunk=0;
  l=1;
  for (i=0;i<T->size;i++)
    if (previous[i]==NONE)
      {
	int length;
	
	length=0;
	for (j=i;j!=NONE;j=next[j]) length++;
	
	if (length>=ISALINE)
	  {
	    int k;
	    double *bottoms,*tops;
	    
	    MYOWN_MALLOC(C->table[l].indices,int,length);
	    C->table[l].length=length;
	    
	    for (j=i,k=0;j!=NONE;j=next[j],k++) C->table[l].indices[k]=j;
	    
	    MYOWN_MALLOC(bottoms,double,length);
	    for (k=0;k<length;k++) 
	      bottoms[k]=T->table[C->table[l].indices[k]].bottom;
	    C->table[l].baseline=
	      guess_accumulation(length,bottoms,1+length/ISALINE);
	    MYOWN_FREE(bottoms,double,length);
	    
	    MYOWN_MALLOC(tops,double,length);
	    for (k=0;k<length;k++) 
	      tops[k]=T->table[C->table[l].indices[k]].top;
	    C->table[l].xline=
	      guess_accumulation(length,tops,1+length/ISALINE);
	    MYOWN_FREE(tops,double,length);
	    
	    /* incrementation and reallocation if needed */
	    PLUSPLUSANDCTRL(l,C->table,line,Csize);
	  }
	else
	  for (j=i;j!=NONE;j=next[j]) 
	    {
	      C->table[0].indices[njunk]=j;

	      /* incrementation and reallocation if needed */
	      PLUSPLUSANDCTRL(njunk,C->table[0].indices,int,junksize);
	    }
      }

  /* shrink junk to its real size */
  MYOWN_REALLOC(C->table[0].indices,int,junksize,njunk);
  C->table[0].length=njunk;
  C->table[0].baseline=-DBL_MAX;
  C->table[0].xline=DBL_MAX;
	
  /* shrink C to its real size */
  MYOWN_REALLOC(C->table,line,Csize,l);
  C->size=l;
  /* don't know if this can be proved, but the following array
     is already sorted when you look at it. */
  qsort (C->table,l,sizeof(line),(comparison_fn_t)compare_baselines);
  
  MYOWN_FREE(badness,double,T->size);
  MYOWN_FREE(next,int,T->size);
  MYOWN_FREE(previous,int,T->size);
}

void tol_dump(tol *C)
{
  int i,k;

  printf("%d lines:\n",C->size);

  for (k=0;k<C->size;k++)
    {
      printf("%02d. %d chars, baseline=%f xline=%f",
	     k,C->table[k].length,C->table[k].baseline,C->table[k].xline);
      for (i=0;i<C->table[k].length;i++)
	printf(" %d",C->table[k].indices[i]);
      printf("\n");
    }
}

void tol_complete_free(tol *C)
{
  int k;
  
  for (k=0;k<C->size;k++)
    MYOWN_FREE(C->table[k].indices,int,C->table[k].length);
  MYOWN_FREE(C->table,line,C->size);
}
