#include "forms.h"
#include "mixer.h"
#include "mixer_c.h"

/* callbacks for form mixerform */
void master_l_cb(FL_OBJECT *ob, long data)
{
    double nval =  fl_get_slider_value(ob);

    if (masterinfo.un.value.num_channels == 1)
	masterinfo.un.value.level[AUDIO_MIXER_LEVEL_MONO] = (int) nval;
    else
	masterinfo.un.value.level[AUDIO_MIXER_LEVEL_LEFT] = (int) nval;

    if (ioctl(mixer_fd, AUDIO_MIXER_WRITE, &masterinfo))
	warn("can't set master volume");
    if (ioctl(mixer_fd, AUDIO_MIXER_READ, &masterinfo))
	warn("can't check master volume");

    set_sliders(fd_mixerform->master_l, fd_mixerform->master_r,
		fd_mixerform->master_mono, fd_mixerform->master_stereo,
		&masterinfo);

}

void master_r_cb(FL_OBJECT *ob, long data)
{
    double nval =  fl_get_slider_value(ob);

    if (masterinfo.un.value.num_channels == 1)
	masterinfo.un.value.level[AUDIO_MIXER_LEVEL_MONO] = (int) nval;
    else
	masterinfo.un.value.level[AUDIO_MIXER_LEVEL_RIGHT] = (int) nval;

    if (ioctl(mixer_fd, AUDIO_MIXER_WRITE, &masterinfo))
	warn("can't set master volume");
    if (ioctl(mixer_fd, AUDIO_MIXER_READ, &masterinfo))
	warn("can't check master volume");

    set_sliders(fd_mixerform->master_l, fd_mixerform->master_r,
		fd_mixerform->master_mono, fd_mixerform->master_stereo,
		&masterinfo);
}

void rec_l_cb(FL_OBJECT *ob, long data)
{
    struct audio_info ainfo;
    double nval =  fl_get_slider_value(ob);
#if 0
    if (fl_get_button(fd_mixerform->rec_mono))
	fl_set_slider_value(fd_mixerform->rec_r, nval);
#endif
    AUDIO_INITINFO(&ainfo);
    ainfo.record.gain = (int) nval;
    snd_fd = open_snd(0);
    if (ioctl(snd_fd, AUDIO_SETINFO, &ainfo))
	warn("can't set record gain");
    if (ioctl(snd_fd, AUDIO_GETINFO, &ainfo) == 0)
	fl_set_slider_value(ob, (double) ainfo.record.gain);
    close_snd(snd_fd);
}

#if 0
void rec_r_cb(FL_OBJECT *ob, long data)
{
    double nval =  fl_get_slider_value(fd_mixerform->rec_r);

    if (fl_get_button(fd_mixerform->rec_mono))
	fl_set_slider_value(fd_mixerform->rec_l, nval);
}
#endif

void play_l_cb(FL_OBJECT *ob, long data)
{
    double nval =  fl_get_slider_value(fd_mixerform->play_l);

    if (playinfo.un.value.num_channels == 1)
	playinfo.un.value.level[AUDIO_MIXER_LEVEL_MONO] = (int) nval;
    else
	playinfo.un.value.level[AUDIO_MIXER_LEVEL_LEFT] = (int) nval;

    if (ioctl(mixer_fd, AUDIO_MIXER_WRITE, &playinfo))
	warn("can't set play volume");
    if (ioctl(mixer_fd, AUDIO_MIXER_READ, &playinfo)) {
	playinfo.un.value.num_channels = 1;
	if (ioctl(mixer_fd, AUDIO_MIXER_READ, &playinfo))
	    warn("can't check play volume");
    }
    set_sliders(fd_mixerform->play_l, fd_mixerform->play_r,
		fd_mixerform->play_mono, fd_mixerform->play_stereo,
		&playinfo);
}

void play_r_cb(FL_OBJECT *ob, long data)
{
    double nval =  fl_get_slider_value(fd_mixerform->play_r);

    if (playinfo.un.value.num_channels == 1)
	playinfo.un.value.level[AUDIO_MIXER_LEVEL_MONO] = (int) nval;
    else
	playinfo.un.value.level[AUDIO_MIXER_LEVEL_RIGHT] = (int) nval;

    if (ioctl(mixer_fd, AUDIO_MIXER_WRITE, &playinfo))
	warn("can't set play volume");
    if (ioctl(mixer_fd, AUDIO_MIXER_READ, &playinfo))
	warn("can't check play volume");

    set_sliders(fd_mixerform->play_l, fd_mixerform->play_r,
		fd_mixerform->play_mono, fd_mixerform->play_stereo,
		&playinfo);
}


void rec_mono_cb(FL_OBJECT *ob, long val)
{
    struct audio_info ainfo;
    AUDIO_INITINFO(&ainfo);

    fl_freeze_form(fd_mixerform->mixerform);
#if 0
    double avg;
    avg = (fl_get_slider_value(fd_mixerform->rec_l) +
	   fl_get_slider_value(fd_mixerform->rec_r)) / 2.0;
    fl_set_slider_value(fd_mixerform->rec_l, avg);
    fl_set_slider_value(fd_mixerform->rec_r, avg);
#endif
    ainfo.record.channels = 1;
    snd_fd = open_snd(0);
    if (ioctl(snd_fd, AUDIO_SETINFO, &ainfo)) {
	warn("can't set mono recording\n");
	if (ioctl(snd_fd, AUDIO_GETINFO, &ainfo) == 0) {
	    fl_set_button(fd_mixerform->rec_stereo,
			  ainfo.record.channels == 2);
	    fl_set_button(fd_mixerform->rec_mono,
			  ainfo.record.channels == 1);
	} else {
	    fl_set_button(fd_mixerform->rec_mono, 0);
	    fl_set_button(fd_mixerform->rec_stereo, 1);
	}
    }
    close_snd(snd_fd);
    rec_rate_cb(fd_mixerform->recrate, 0);
    fl_unfreeze_form(fd_mixerform->mixerform);
}

void rec_stereo_cb(FL_OBJECT *ob, long val)
{
    struct audio_info ainfo;
    AUDIO_INITINFO(&ainfo);

    ainfo.record.channels = 2;
    snd_fd = open_snd(0);
    if (ioctl(snd_fd, AUDIO_SETINFO, &ainfo)) {
	warn("can't set stereo recording\n");
	if (ioctl(snd_fd, AUDIO_GETINFO, &ainfo) == 0) {
	    fl_set_button(fd_mixerform->rec_stereo,
			  ainfo.record.channels == 2);
	    fl_set_button(fd_mixerform->rec_mono,
			  ainfo.record.channels == 1);
	} else {
	    fl_set_button(fd_mixerform->rec_mono, 1);
	    fl_set_button(fd_mixerform->rec_stereo, 0);
	}
    }
    close_snd(snd_fd);
    rec_rate_cb(fd_mixerform->recrate, 0);
}

void master_mono_cb(FL_OBJECT *ob, long val)
{
    double avg;

    avg = (fl_get_slider_value(fd_mixerform->master_l) +
	   fl_get_slider_value(fd_mixerform->master_r)) / 2.0;
    fl_set_slider_value(fd_mixerform->master_l, avg);
    fl_set_slider_value(fd_mixerform->master_r, avg);
    masterinfo.un.value.num_channels = 1;
    master_l_cb(fd_mixerform->master_l, 0);

    
}

void master_stereo_cb(FL_OBJECT *ob, long val)
{
    struct audio_info ainfo;
    AUDIO_INITINFO(&ainfo);
    ainfo.play.channels = 2;
    snd_fd = open_snd(0);
    if (ioctl(snd_fd, AUDIO_SETINFO, &ainfo))
	warn("can't set stereo playback\n");
    close_snd(snd_fd);

    masterinfo.un.value.num_channels = 2;
    master_l_cb(fd_mixerform->master_l, 0);
}

void play_mono_cb(FL_OBJECT *ob, long val)
{
    struct audio_info ainfo;

    AUDIO_INITINFO(&ainfo);
    ainfo.play.channels = 1;
    snd_fd = open_snd(0);
    if (ioctl(snd_fd, AUDIO_SETINFO, &ainfo))
	warn("can't set mono playback\n");


    if (ioctl(mixer_fd, AUDIO_MIXER_READ, &playinfo))
	warn("can't check play volume");

    if (playinfo.un.value.num_channels == 2) {
	playinfo.un.value.level[AUDIO_MIXER_LEVEL_MONO] =
	    (playinfo.un.value.level[AUDIO_MIXER_LEVEL_LEFT] +
	     playinfo.un.value.level[AUDIO_MIXER_LEVEL_RIGHT]) / 2;
    }
    playinfo.un.value.num_channels = 1;
    if (ioctl(mixer_fd, AUDIO_MIXER_WRITE, &playinfo)) {
	warn("can't set nchans");
	(void) ioctl(mixer_fd, AUDIO_MIXER_READ, &playinfo);
	goto out;
    }
    close_snd(snd_fd);

out:
    if (!val)
	play_rate_cb(fd_mixerform->playrate, 0);
    set_sliders(fd_mixerform->play_l, fd_mixerform->play_r,
		fd_mixerform->play_mono, fd_mixerform->play_stereo,
		&playinfo);

}

void play_stereo_cb(FL_OBJECT *ob, long val)
{
    struct audio_info ainfo;
    AUDIO_INITINFO(&ainfo);
    ainfo.play.channels = 2;
    snd_fd = open_snd(0);
    if (ioctl(snd_fd, AUDIO_SETINFO, &ainfo))
	warn("can't set stereo playback\n");

    if (ioctl(mixer_fd, AUDIO_MIXER_READ, &playinfo))
	warn("can't check play volume");
    close_snd(snd_fd);

    playinfo.un.value.num_channels = 2;

    if (!val)
	play_rate_cb(fd_mixerform->playrate, 0);
    play_l_cb(fd_mixerform->play_l, 0);
}

void
enc_cb(FL_OBJECT *ob, long val)
{
    struct audio_info ainfo;
    char *txt = fl_get_choice_text(ob);
    int ochoice = fl_get_choice(ob);
    int enc = get_encoding(txt);
    int oenc;
    char warnbuf[BUFSIZ];
    char warnbuf2[BUFSIZ];

    snd_fd = open_snd(0);
    if (ioctl(snd_fd, AUDIO_GETINFO, &ainfo))
	warn("can't get audio info");
    if (val) {
	oenc = ainfo.record.encoding;
	AUDIO_INITINFO(&ainfo);
	ainfo.record.encoding = enc;
    } else {
	oenc = ainfo.play.encoding;
	AUDIO_INITINFO(&ainfo);
	ainfo.play.encoding = enc;
    }
    if (ioctl(snd_fd, AUDIO_SETINFO, &ainfo)) {
	int err = errno;
	sprintf(warnbuf, "Can't set %s encoding",
		val ? "recording" : "playback");
	sprintf(warnbuf2, "Encoding `%s' got the error `%s'",
		txt, strerror(err));
	fl_show_alert(warnbuf, warnbuf2, 0, 0);
	fl_set_choice(ob, oenc);
	fl_set_choice_item_mode(ob, enc, FL_PUP_GRAY);
    } else if (0 == ioctl(snd_fd, AUDIO_GETINFO, &ainfo)) {
	fl_set_choice(fd_mixerform->rec_encoding, ainfo.record.encoding);
	fl_set_choice(fd_mixerform->play_encoding, ainfo.play.encoding);
    }
    close_snd(snd_fd);
}

void
rec_src_cb(FL_OBJECT *ob, long val)
{
    DBT key, data;
    struct audio_info ainfo;
    devdata_db_t dvinfo;
    int v, port, i, err;
    char warnbuf[BUFSIZ];
    char warnbuf2[BUFSIZ];

    snd_fd = open_snd(0);
    if (ioctl(snd_fd, AUDIO_GETINFO, &ainfo))
	warn("can't get audio info");
    port = ainfo.record.port;

    key.data = fl_get_choice_text(ob);
    key.size = strlen(key.data)+1;
    v = (*dev_db_name->get)(dev_db_name, &key, &data, 0);
    if (v == 0) {
	AUDIO_INITINFO(&ainfo);
	bcopy(data.data, &dvinfo, sizeof(dvinfo));
	ainfo.record.port = dvinfo.index;
	if (ioctl(snd_fd, AUDIO_SETINFO, &ainfo)) {
	    sprintf(warnbuf2, "The error was `%s'", strerror(errno));
	    sprintf(warnbuf, "Can't set recording source to `%s'", key.data);
	    fl_show_alert(warnbuf, warnbuf2, 0, 0);

	    key.data = &port;
	    key.size = sizeof(port);
	    if ((*dev_db_index->get)(dev_db_index, &key, &data, 0) == 0) {
		bcopy(data.data, &dvinfo, sizeof(dvinfo));
		fl_set_choice_text(fd_mixerform->rec_source, dvinfo.name);
	    }
	}
    } else
	warnx("Hey, %s (%d) isn't valid (%d)?", key.data, key.size, v);
    close_snd(snd_fd);
}

void
rec_rate_cb(FL_OBJECT *ob, long val)
{
    struct audio_info ainfo;
    char inputval[32];

    if (ioctl(mixer_fd, AUDIO_MIXER_READ, &playinfo))
	warn("can't check play volume");
    if (playinfo.un.value.num_channels == 1)
	play_mono_cb(fd_mixerform->play_mono, 1);
    else
	play_stereo_cb(fd_mixerform->play_stereo, 1);
    AUDIO_INITINFO(&ainfo);
    ainfo.record.sample_rate = atoi(fl_get_input(ob));
    snd_fd = open_snd(0);
    if (ioctl(snd_fd, AUDIO_SETINFO, &ainfo))
	warn("can't set record rate to %s", fl_get_input(ob));
    if (ioctl(snd_fd, AUDIO_GETINFO, &ainfo) == 0) {
	sprintf(inputval, "%d", ainfo.record.sample_rate);
	fl_set_input(ob, inputval);
    }	    
    close_snd(snd_fd);
    if (!val)
	play_rate_cb(fd_mixerform->playrate, 1);
}

void
play_rate_cb(FL_OBJECT *ob, long val)
{
    struct audio_info ainfo;
    char inputval[32];

    if (ioctl(mixer_fd, AUDIO_MIXER_READ, &playinfo))
	warn("can't check play volume");
    if (playinfo.un.value.num_channels == 1)
	play_mono_cb(fd_mixerform->play_mono, 1);
    else
	play_stereo_cb(fd_mixerform->play_stereo, 1);

    AUDIO_INITINFO(&ainfo);
    ainfo.play.sample_rate = atoi(fl_get_input(ob));
    snd_fd = open_snd(0);
    if (ioctl(snd_fd, AUDIO_SETINFO, &ainfo))
	warn("can't set record rate to %s", fl_get_input(ob));
    if (ioctl(snd_fd, AUDIO_GETINFO, &ainfo) == 0) {
	sprintf(inputval, "%d", ainfo.play.sample_rate);
	fl_set_input(ob, inputval);
    }	    
    close_snd(snd_fd);
    if (!val)
	rec_rate_cb(fd_mixerform->recrate, 1);
}

void
mix_src_cb(FL_OBJECT *ob, long val)
{
    DBT key, data;
    struct audio_info ainfo;
    devdata_db_t dbitem;
    int v, port, i, err;
    char *txt = fl_get_choice_text(ob);
    char mixtxt[MAX_AUDIO_DEV_LEN + 16];

    fl_freeze_form(fd_mixerform->mixerform);


    key.data = txt;
    key.size = strlen(txt)+1;
    v = (*dev_db_name->get)(dev_db_name, &key, &data, 0);

    if (v == 0) {
	bcopy(data.data, &dbitem, sizeof(dbitem));
	playinfo.un.value.num_channels = 2;
	playinfo.dev = dbitem.index;
	if (ioctl(mixer_fd, AUDIO_MIXER_READ, &playinfo)) {
	    playinfo.un.value.num_channels = 1;
	    if (ioctl(mixer_fd, AUDIO_MIXER_READ, &playinfo)) {
		/* alert */
		warn("can't fetch mixer level for item `%s'", dbitem.name);
	    }
	}
	set_sliders(fd_mixerform->play_l, fd_mixerform->play_r,
		    fd_mixerform->play_mono, fd_mixerform->play_stereo,
		    &playinfo);
    } else
	warnx("Hey, %s (%d) isn't valid (%d)?", key.data, key.size, v);

    sprintf(mixtxt, "%s volume", txt);
    fl_set_object_label(fd_mixerform->srcvol_text, mixtxt);
    fl_redraw_object(fd_mixerform->srcvol_text);

    sprintf(mixtxt, "%s mode", txt);
    fl_set_object_label(fd_mixerform->srcmix_text, mixtxt);
    fl_redraw_object(fd_mixerform->srcmix_text);

out:
    fl_unfreeze_form(fd_mixerform->mixerform);
}

void
quit_cb(FL_OBJECT *ob, long val)
{
    exit(0);
}

void
dac_mode_cb(FL_OBJECT *ob, long val)
{
    int mode = fl_get_choice(ob);
    struct audio_info ainfo;

    AUDIO_INITINFO(&ainfo);
    ainfo.mode = mode - 1;
    if (ainfo.mode & 1<<AUMODE_PLAY)
	ainfo.play.pause = 0;
    if (ainfo.mode & 1<<AUMODE_RECORD)
	ainfo.record.pause = 0;

    snd_fd = open_snd(0);
    if (ioctl(snd_fd, AUDIO_SETINFO, &ainfo))
	warn("can't set play/record mode");
    /*
     * fetching mode will only tell us AUMODE_PLAY or AUMODE_RECORD--not
     * very useful!
     */
#if 0
    if (ioctl(snd_fd, AUDIO_GETINFO, &ainfo) == 0) {
	fl_set_choice(ob, ainfo.mode+1);
    }
#endif
    close_snd(snd_fd);
}
