#include <sys/types.h>

#include <sys/ioctl.h>
#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <err.h>
#include <fcntl.h>
#include <db.h>
#include <errno.h>

#include <sys/audioio.h>
/* XXX */
#define AudioNlinear "Linear"
#define AudioNulaw "U-Law"
#define AudioNalaw "A-Law"
#define AudioNpcm16 "PCM-16"
#define AudioNpcm8 "PCM-8"
#define AudioNadpcm "ADPCM"

#define MIXER_REC_SRC		0x01
#define MIXER_MASTER_VOL	0x02	/* can't use this on generic slider */

typedef struct devdata {
    int index;				/* mixer index */
    char name[MAX_AUDIO_DEV_LEN];	/* mixer name */
    int type;				/* mixer type: CLASS, ENUM, SET, VALUE */
    int devclass;			/* mixer class: input, output, etc. (device specific mapping, argh) */
    int srcflags;			/* see above */
} devdata_db_t;

extern const char *
encoding_text(int);

extern int
open_snd(int mustwork);

extern void
close_snd(int);

extern void
set_sliders(FL_OBJECT *slider_l,
	    FL_OBJECT *slider_r,
	    FL_OBJECT *st_button,
	    FL_OBJECT *m_button,
	    mixer_ctrl_t *mixinfo);

extern DB *dev_db_name, *dev_db_index;
extern int mixer_fd;
extern int snd_fd;
extern mixer_ctrl_t masterinfo;
extern mixer_ctrl_t playinfo;
extern mixer_ctrl_t recinfo;
extern FD_mixerform *fd_mixerform;
