/*
** A simple implementation of a resizing hash table
**
** Copyright (C) 2000 by Kevin L. Mitchell <klmitch@mit.edu>
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
**
** @(#)$Id: ht_find.c,v 1.6 2000/08/09 01:19:23 klmitch Exp $
*/
#include <string.h>

#include "hash.h"
#include "hash_int.h"

RCSTAG("@(#)$Id: ht_find.c,v 1.6 2000/08/09 01:19:23 klmitch Exp $");

_h_ul
ht_find(hash_tab *table, _h_uc *key, int key_len, hash_ent **entry_p)
{
  _h_ul hash;
  hash_ent *entry;
  hash_key hkey;

  if (!ht_verify(table) || !key)
    return HASH_ERR_BADARGS;

  if (!ht_count(table))
    return HASH_ERR_NOENT;

  hkey.hk_key = key;
  hkey.hk_length = key_len ? key_len : strlen((char *)key);

  hash = (*table->ht_func)(table, &hkey, table->ht_modulus);

  for (entry = table->ht_table[hash]; entry; entry = entry->he_next)
    if ((*table->ht_comp)(table, &entry->he_key, &hkey)) {
      if (entry_p)
	*entry_p = entry;
      return 0;
    }

  return HASH_ERR_NOENT;
}
