/*
** A simple implementation of a resizing hash table
**
** Copyright (C) 2000 by Kevin L. Mitchell <klmitch@mit.edu>
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
**
** @(#)$Id: ht_init.c,v 1.7 2000/08/02 19:34:02 klmitch Exp $
*/
#include <stdlib.h>
#include <errno.h>

#include "hash.h"
#include "hash_int.h"

RCSTAG("@(#)$Id: ht_init.c,v 1.7 2000/08/02 19:34:02 klmitch Exp $");

_h_ul
ht_init(hash_tab *table, _h_ul init_mod, hash_func func, hash_comp comp,
	void *extra)
{
  int i;

  initialize_hash_error_table();

  if (!table)
    return HASH_ERR_BADARGS;

  table->ht_modulus = _hash_prime(init_mod);
  table->ht_count = 0;
  table->ht_rollover = _hash_rollover(table->ht_modulus);
  table->ht_rollunder = _hash_rollunder(table->ht_modulus);
  table->ht_table = NULL;
  table->ht_func = func ? func : _hash_func;
  table->ht_comp = comp ? comp : _hash_compare;
  table->ht_extra = extra;
  table->ht_flags = 0;

  if (table->ht_modulus) {
    if (!(table->ht_table =
	  (hash_ent **)malloc(table->ht_modulus * sizeof(hash_ent *))))
      return errno;

    for (i = 0; i < table->ht_modulus; i++)
      table->ht_table[i] = NULL;
  }

  table->ht_magic = HASH_TAB_MAGIC;

  return 0;
}
