/*
** A simple implementation of a resizing hash table
**
** Copyright (C) 2000 by Kevin L. Mitchell <klmitch@mit.edu>
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
**
** @(#)$Id: hash_compare.c,v 1.5 2000/01/27 03:48:55 klmitch Exp $
*/
#include <string.h>

#include "hash.h"
#include "hash_int.h"

RCSTAG("@(#)$Id: hash_compare.c,v 1.5 2000/01/27 03:48:55 klmitch Exp $");

_h_ul
_hash_compare(hash_tab *table, hash_key *key1, hash_key *key2)
{
  return (key1->hk_length == key2->hk_length &&
	  !memcmp((void *)key1->hk_key, (void *)key2->hk_key,
		  key1->hk_length));
}
