/*
** A simple implementation of a resizing hash table
**
** Copyright (C) 2000 by Kevin L. Mitchell <klmitch@mit.edu>
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
**
** @(#)$Id: he_init.c,v 1.4 2000/01/27 03:48:56 klmitch Exp $
*/
#include <stdlib.h>
#include <string.h>

#include "hash.h"
#include "hash_int.h"

RCSTAG("@(#)$Id: he_init.c,v 1.4 2000/01/27 03:48:56 klmitch Exp $");

_h_ul
he_init(hash_ent *entry, _h_uc *init_key, int key_len, void *init_value)
{
  initialize_hash_error_table();

  if (!entry || !init_key)
    return HASH_ERR_BADARGS;

  if (!key_len)
    key_len = strlen((char *)init_key);

  entry->he_next = NULL;
  entry->he_prev_p = NULL;
  entry->he_table = NULL;
  entry->he_hash = 0;
  entry->he_key.hk_length = key_len;
  entry->he_key.hk_key = init_key;
  entry->he_value = init_value;

  entry->he_magic = HASH_ENT_MAGIC;

  return 0;
}
