/*
** A simple implementation of a resizing hash table
**
** Copyright (C) 2000 by Kevin L. Mitchell <klmitch@mit.edu>
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
**
** @(#)$Id: ht_resize.c,v 1.5 2000/08/09 18:51:55 klmitch Exp $
*/
#include <stdlib.h>
#include <errno.h>

#include "hash.h"
#include "hash_int.h"

RCSTAG("@(#)$Id: ht_resize.c,v 1.5 2000/08/09 18:51:55 klmitch Exp $");

_h_ul
ht_resize(hash_tab *table, _h_ul new_size)
{
  hash_ent **htab, *entry, *nentry;
  _h_ul modulus;
  int i;

  if (!ht_verify(table))
    return HASH_ERR_BADARGS;

  if (table->ht_flags & HASH_FLAGS_FREEZE) {
    table->ht_flags |= HASH_FLAGS_RESIZE;
    return 0;
  } else
    table->ht_flags &= HASH_FLAGS_RESIZE;

  if (new_size <= 0)
    new_size = 1;

  modulus = _hash_prime((new_size * 4) / 3);

  if (!(htab = (hash_ent **)malloc(modulus * sizeof(hash_ent *))))
    return errno;

  for (i = 0; i < modulus; i++)
    htab[i] = NULL;

  for (i = 0; i < table->ht_modulus; i++)
    for (entry = table->ht_table[i]; entry; entry = nentry) {
      nentry = entry->he_next;

      entry->he_hash = (*table->ht_func)(table, &entry->he_key, modulus);

      entry->he_next = htab[entry->he_hash];
      entry->he_prev_p = &htab[entry->he_hash];

      if (htab[entry->he_hash])
	htab[entry->he_hash]->he_prev_p = &entry->he_next;
      htab[entry->he_hash] = entry;
    }

  if (table->ht_table)
    free(table->ht_table);

  table->ht_modulus = modulus;
  table->ht_rollover = _hash_rollover(modulus);
  table->ht_rollunder = _hash_rollunder(modulus);
  table->ht_table = htab;

  return 0;
}
