/*
** A simple implementation of a resizing hash table
**
** Copyright (C) 2000 by Kevin L. Mitchell <klmitch@mit.edu>
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
**
** @(#)$Id: he_rekey.c,v 1.2 2000/01/27 03:48:56 klmitch Exp $
*/
#include <stdlib.h>
#include <string.h>

#include "hash.h"
#include "hash_int.h"

RCSTAG("@(#)$Id: he_rekey.c,v 1.2 2000/01/27 03:48:56 klmitch Exp $");

_h_ul
he_rekey(hash_ent *entry, _h_uc *init_key, int key_len)
{
  if (!he_verify(entry) || !init_key)
    return HASH_ERR_BADARGS;

  if (!key_len)
    key_len = strlen((char *)init_key);

  if (!entry->he_prev_p)
    return HASH_ERR_UNUSED;

  if (!ht_verify(entry->he_table))
    return HASH_ERR_BADTAB;

  entry->he_key.hk_length = key_len;
  entry->he_key.hk_key = init_key;

  if (entry->he_next) /* unlink */
    entry->he_next->he_prev_p = entry->he_prev_p;
  *entry->he_prev_p = entry->he_next;

  /* rehash */
  entry->he_hash = (*entry->he_table->ht_func)(entry->he_table, &entry->he_key,
					       entry->he_table->ht_modulus);

  /* and relink */
  entry->he_next = entry->he_table->ht_table[entry->he_hash];
  entry->he_prev_p = &entry->he_table->ht_table[entry->he_hash];

  if (entry->he_table->ht_table[entry->he_hash])
    entry->he_table->ht_table[entry->he_hash]->he_prev_p = &entry->he_next;
  entry->he_table->ht_table[entry->he_hash] = entry;

  return 0;
}
