/*
** A simple implementation of a resizing hash table
**
** Copyright (C) 2000 by Kevin L. Mitchell <klmitch@mit.edu>
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
**
** @(#)$Id: ht_add.c,v 1.5 2000/01/27 03:48:56 klmitch Exp $
*/
#include "hash.h"
#include "hash_int.h"

RCSTAG("@(#)$Id: ht_add.c,v 1.5 2000/01/27 03:48:56 klmitch Exp $");

_h_ul
ht_add(hash_tab *table, hash_ent *entry)
{
  _h_ul retval;

  if (!ht_verify(table) || !he_verify(entry))
    return HASH_ERR_BADARGS;

  if (entry->he_prev_p)
    return HASH_ERR_BUSY;

  if (++table->ht_count > table->ht_rollover)
    if ((retval = ht_resize(table, table->ht_count)))
      return retval;

  entry->he_hash = (*table->ht_func)(table, &entry->he_key, table->ht_modulus);

  entry->he_next = table->ht_table[entry->he_hash];
  entry->he_prev_p = &table->ht_table[entry->he_hash];

  if (table->ht_table[entry->he_hash])
    table->ht_table[entry->he_hash]->he_prev_p = &entry->he_next;
  table->ht_table[entry->he_hash] = entry;

  entry->he_table = table;

  return 0;
}
