/*
** A simple implementation of a resizing hash table
**
** Copyright (C) 2000 by Kevin L. Mitchell <klmitch@mit.edu>
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
**
** @(#)$Id: ht_free.c,v 1.2 2000/01/27 03:48:56 klmitch Exp $
*/
#include <stdlib.h>

#include "hash.h"
#include "hash_int.h"

RCSTAG("@(#)$Id: ht_free.c,v 1.2 2000/01/27 03:48:56 klmitch Exp $");

_h_ul
ht_free(hash_tab *table)
{
  if (!ht_verify(table))
    return HASH_ERR_BADARGS;

  if (table->ht_count)
    return HASH_ERR_NOTEMPTY;

  free(table->ht_table);

  table->ht_table = NULL;
  table->ht_modulus = 0;

  return 0;
}
