/*
** A simple implementation of a resizing hash table
**
** Copyright (C) 2000 by Kevin L. Mitchell <klmitch@mit.edu>
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
**
** @(#)$Id: ht_iter.c,v 1.3 2000/01/27 03:48:56 klmitch Exp $
*/
#include "hash.h"
#include "hash_int.h"

RCSTAG("@(#)$Id: ht_iter.c,v 1.3 2000/01/27 03:48:56 klmitch Exp $");

_h_ul
ht_iter(hash_tab *table, hash_iter iter_func, void *extra)
{
  _h_ul retval;
  int i;
  hash_ent *entry;

  if (!ht_verify(table) || !iter_func)
    return HASH_ERR_BADARGS;

  for (i = 0; i < table->ht_modulus; i++)
    for (entry = table->ht_table[i]; entry; entry = entry->he_next)
      if ((retval = (*iter_func)(table, entry, extra)))
	return retval;

  return 0;
}
