/*
** A simple implementation of a resizing hash table
**
** Copyright (C) 2000 by Kevin L. Mitchell <klmitch@mit.edu>
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
**
** @(#)$Id: ht_rem.c,v 1.4 2000/01/27 03:48:56 klmitch Exp $
*/
#include <stdlib.h>

#include "hash.h"
#include "hash_int.h"

RCSTAG("@(#)$Id: ht_rem.c,v 1.4 2000/01/27 03:48:56 klmitch Exp $");

_h_ul
ht_rem(hash_ent *entry)
{
  _h_ul retval;

  if (!he_verify(entry))
    return HASH_ERR_BADARGS;

  if (!entry->he_prev_p)
    return HASH_ERR_UNUSED;

  if (!ht_verify(entry->he_table))
    return HASH_ERR_BADTAB;

  if (--entry->he_table->ht_count < entry->he_table->ht_rollunder)
    if ((retval = ht_resize(entry->he_table, entry->he_table->ht_count)))
      return retval;

  if (entry->he_next)
    entry->he_next->he_prev_p = entry->he_prev_p;
  *entry->he_prev_p = entry->he_next;

  entry->he_next = NULL;
  entry->he_prev_p = NULL;
  entry->he_table = NULL;
  entry->he_hash = 0;

  return 0;
}
