/*
** Copyright (C) 2000 by Kevin L. Mitchell <klmitch@mit.edu>
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
**
** @(#)$Id: le_init.c,v 1.1 2000/01/27 20:05:52 klmitch Exp $
*/
#include "link.h"
#include "link_int.h"

RCSTAG("@(#)$Id: le_init.c,v 1.1 2000/01/27 20:05:52 klmitch Exp $");

_l_ul
le_init(link_elem *element, void *object)
{
  initialize_link_error_table();

  if (!element || !object)
    return LINK_ERR_BADARGS;

  element->le_next = 0;
  element->le_prev_p = 0;
  element->le_object = object;
  element->le_head = 0;
  element->le_flags = 0;

  element->le_magic = LINK_ELEM_MAGIC;

  return 0;
}
