/*
** Copyright (C) 2000 by Kevin L. Mitchell <klmitch@mit.edu>
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
**
** @(#)$Id: ll_find.c,v 1.3 2000/01/31 19:21:21 klmitch Exp $
*/
#include "link.h"
#include "link_int.h"

RCSTAG("@(#)$Id: ll_find.c,v 1.3 2000/01/31 19:21:21 klmitch Exp $");

_l_ul
ll_find(link_head *list, link_elem **element_p, link_comp comp_func, void *key)
{
  link_elem *element;

  if (!ll_verify(list) || !element_p || !comp_func || !key)
    return LINK_ERR_BADARGS;

  for (element = list->lh_list; element; element = element->le_next)
    if (!comp_func(element->le_object, key)) {
      *element_p = element;
      return 0;
    }

  return LINK_ERR_NOELEM;
}
