/*
** Copyright (C) 2000 by Kevin L. Mitchell <klmitch@mit.edu>
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
**
** @(#)$Id: ll_flush.c,v 1.1 2000/01/27 20:05:52 klmitch Exp $
*/
#include "link.h"
#include "link_int.h"

RCSTAG("@(#)$Id: ll_flush.c,v 1.1 2000/01/27 20:05:52 klmitch Exp $");

_l_ul
ll_flush(link_head *list)
{
  if (!ll_verify(list))
    return LINK_ERR_BADARGS;

  while (list->lh_list)
    ll_rem(list->lh_list);

  list->lh_list = 0;
  list->lh_count = 0;

  return 0;
}
