/*
** A simple module loader/unloader
**
** Copyright (C) 2000 by Kevin L. Mitchell <klmitch@mit.edu>
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
**
** @(#)$Id: mod_clear.c,v 1.2 2000/01/27 03:39:44 klmitch Exp $
*/
#include <dlfcn.h>

#include "mod.h"
#include "mod_int.h"

RCSTAG("@(#)$Id: mod_clear.c,v 1.2 2000/01/27 03:39:44 klmitch Exp $");

_mod_ul
mod_clear(void)
{
  _mod_ul retval;
  module *cursor, *next;

  initialize_mod_error_table();

  for (cursor = _mod_modules; cursor; cursor = next) {
    next = cursor->mod_next;

    if (!cursor->mod_ref)
      if ((retval = mod_unload(cursor)))
	return retval;
  }

  return 0;
}
