/*
** A simple module loader/unloader
**
** Copyright (C) 2000 by Kevin L. Mitchell <klmitch@mit.edu>
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
**
** @(#)$Id: mod_unload.c,v 1.3 2000/01/27 03:39:45 klmitch Exp $
*/
#include <dlfcn.h>

#include "mod.h"
#include "mod_int.h"

RCSTAG("@(#)$Id: mod_unload.c,v 1.3 2000/01/27 03:39:45 klmitch Exp $");

_mod_ul
mod_unload(module *mod)
{
  _mod_ul retval;

  initialize_mod_error_table();

  if (!mod_verify(mod))
    return MOD_ERR_BADMOD;

  if (!mod->mod_prev_p)
    return MOD_ERR_NOTINUSE;

  if (mod->mod_ref)
    return MOD_ERR_INUSE;

  if (mod->mod_fini)
    if ((retval = (*mod->mod_fini)(mod)))
      return retval;

  if (mod->mod_next)
    mod->mod_next->mod_prev_p = mod->mod_prev_p;
  *mod->mod_prev_p = mod->mod_next;

  dlclose(mod->mod_handle);

  return 0;
}
