/*
** A simple module loader/unloader
**
** Copyright (C) 2000 by Kevin L. Mitchell <klmitch@mit.edu>
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
**
** @(#)$Id: mod_load.c,v 1.4 2000/08/18 14:33:17 klmitch Exp $
*/
#include <dlfcn.h>

#include "mod.h"
#include "mod_int.h"

RCSTAG("@(#)$Id: mod_load.c,v 1.4 2000/08/18 14:33:17 klmitch Exp $");

module *_mod_modules = 0;

_mod_ul
mod_load(char *filename, void *extra, module **mod_p)
{
  _mod_ul retval;
  void *handle;
  module *mod;

  initialize_mod_error_table();

  if (!filename)
    return MOD_ERR_BADARGS;

  if (!(handle = dlopen(filename, RTLD_LAZY | RTLD_LOCAL)))
    return MOD_ERR_CANTOPEN;

  if (!(mod = (module *)dlsym(handle, MOD_DESC_NAME))) {
    dlclose(handle);
    return MOD_ERR_NOTMOD;
  }

  if (!mod_verify(mod) || !mod->mod_name || !mod->mod_init) {
    dlclose(handle);
    return MOD_ERR_BADMOD;
  }

  if ((retval = (*mod->mod_init)(mod, extra))) {
    dlclose(handle);
    return retval;
  }

  mod->mod_handle = handle;

  mod->mod_prev_p = &_mod_modules;
  mod->mod_next = _mod_modules;
  if (_mod_modules)
    _mod_modules->mod_prev_p = &mod;
  _mod_modules = mod;

  if (mod_p)
    *mod_p = mod;

  return 0;
}
