/*
** Copyright (C) 2000 by Kevin L. Mitchell <klmitch@mit.edu>
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
**
** @(#)$Id: _str_more.c,v 1.3 2000/07/23 01:39:44 klmitch Exp $
*/
#include <errno.h>
#include <stdlib.h>

#include "str.h"
#include "str_int.h"

RCSTAG("@(#)$Id: _str_more.c,v 1.3 2000/07/23 01:39:44 klmitch Exp $");

_s_ul
_str_more(str *s, _s_ui howmuch)
{
  _s_ui newsize;
  char *t;

  /* calculate the new size to use... */
  newsize = _str_size(s) ? _str_size(s) : STR_BUF;
  while (str_len(s) + howmuch + 1 > newsize)
    newsize <<= 2;

  /* get the larger chunk of memory... */
  if (!(t = (char *)realloc(str_str(s), newsize)))
    return ENOMEM;

  str_str(s) = t;
  _str_size(s) = newsize;

  return 0;
}
