/*
** Copyright (C) 2000 by Kevin L. Mitchell <klmitch@mit.edu>
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
**
** @(#)$Id: str_free.c,v 1.3 2000/07/22 16:29:13 klmitch Exp $
*/
#include <stdlib.h>

#include "str.h"
#include "str_int.h"

RCSTAG("@(#)$Id: str_free.c,v 1.3 2000/07/22 16:29:13 klmitch Exp $");

_s_ul
str_free(str *s)
{
  if (!str_verify(s))
    return STR_ERR_BADARGS;

  if (!--(_str_ref(s))) { /* if this is the last copy... */
    if (str_str(s))
      free(str_str(s));

    s->s_magic = 0;
    str_str(s) = 0;
    str_len(s) = 0;
    _str_size(s) = 0;

    free(s);
  }

  return 0;
}
