/*
** Copyright (C) 2000 by Kevin L. Mitchell <klmitch@mit.edu>
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
**
** @(#)$Id: str_int.h,v 1.2 2000/07/22 20:26:27 klmitch Exp $
*/
#ifndef __include_str_int_h__
#define __include_str_int_h__

#include "str.h"

#ifdef __GNUC__
# if (__GNUC__ < 2) || (__GNUC__ == 2 && __GNUC_MINOR__ < 7)
# define __attribute__(A)
# endif
#else
# define __attribute__(A)
#endif

#define RCSTAG(tag) static char rcsid[] __attribute__((unused)) = tag

#define STR_BUF		(1<<5)	/* initial buffer size */

extern _s_ul _str_more(str *s, _s_ui howmuch);

#endif /* __include_str_int_h__ */
