/*
** Copyright (C) 2000 by Kevin L. Mitchell <klmitch@mit.edu>
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
**
** @(#)$Id: str_append.c,v 1.1 2000/07/22 15:37:20 klmitch Exp $
*/
#include <string.h>

#include "str.h"
#include "str_int.h"

RCSTAG("@(#)$Id: str_append.c,v 1.1 2000/07/22 15:37:20 klmitch Exp $");

_s_ul
str_append(str *s, char *str, _s_ui len)
{
  _s_ul retval;
  _s_ui i;

  if (!str_verify(s))
    return STR_ERR_BADARGS;

  if (!str || (!len && !*str))
    return 0; /* nothing to append */

  if (!len) /* how much do we need to add? */
    len = strlen(str);

  if (str_len(s) + len + 1 > _str_size(s) && (retval = _str_more(s, len)))
    return retval; /* couldn't extend string */

  for (i = 0; i < len; i++) /* copy the string over... */
    (str_str(s))[(str_len(s))++] = str[i];
  (str_str(s))[str_len(s)] = '\0'; /* and terminate it */

  return 0;
}
