/*
** Copyright (C) 2000 by Kevin L. Mitchell <klmitch@mit.edu>
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
**
** @(#)$Id: str_init.c,v 1.5 2000/08/09 14:34:53 klmitch Exp $
*/
#include <errno.h>
#include <stdlib.h>

#include "str.h"
#include "str_int.h"

RCSTAG("@(#)$Id: str_init.c,v 1.5 2000/08/09 14:34:53 klmitch Exp $");

_s_ul
str_init(str **s, char *string, _s_ui len)
{
  _s_ul retval;
  str *ts;

  initialize_str_error_table();

  if (!s)
    return STR_ERR_BADARGS;

  if (!(ts = (str *)malloc(sizeof(str))))
    return ENOMEM;

  ts->s_magic = STR_MAGIC; /* initialize str... */
  str_str(ts) = 0;
  str_len(ts) = 0;
  _str_size(ts) = 0;
  _str_ref(ts) = 1;

  if (string && (len || *string) &&
      (retval = str_append(ts, string, len))) {
    free(ts);
    return retval;
  }

  *s = ts;

  return 0;
}
