# $Id: bogofilter.spec.in,v 1.19 2003/01/31 00:19:53 m-a Exp $

Name: bogofilter
Version: 0.10.2
Release: 1
URL: http://bogofilter.sourceforge.net
Source0: %{name}-%{version}.tar.gz
License: GPL
Group: Applications/Internet
Summary: fast anti-spam filtering by Bayesian statistical analysis
Buildroot: %{_tmppath}/%{name}-%{version}-root
%define mydocdir %{_docdir}/%{name}

%description
Bogofilter is a Bayesian spam filter.  In its normal mode of
operation, it takes an email message or other text on standard input,
does a statistical check against lists of "good" and "bad" words, and
returns a status code indicating whether or not the message is spam.
Bogofilter is designed with fast algorithms  (including Berkeley DB system),
coded directly in C, and tuned for speed, so it can be used for production
by sites that process a lot of mail.

%prep
%setup
CFLAGS="$RPM_OPT_FLAGS" \
./configure \
  --prefix=%{_prefix} \
  --mandir=%{_mandir} \
  --sysconfdir=%{_sysconfdir}

%build
make all check

%install
[ -n "$RPM_BUILD_ROOT" -a "$RPM_BUILD_ROOT" != / ] && rm -rf $RPM_BUILD_ROOT
make DESTDIR=${RPM_BUILD_ROOT} install-strip
cp $RPM_BUILD_ROOT%{_sysconfdir}/bogofilter.cf.example \
   $RPM_BUILD_ROOT%{_sysconfdir}/bogofilter.cf
gzip -f -9 $RPM_BUILD_ROOT/%{_mandir}/*/*.[1-9]

for a in xml html contrib ; do
  mkdir -p .inst/$a
done

for i in doc/*.xml ; do
  install -m644 $i .inst/xml
done

for i in doc/*.html ; do
  install -m644 $i .inst/html
done

files=`find contrib -maxdepth 1 -type f | grep -v Makefile`
for i in $files ; do
  case $i in
    *.o|*.obj) continue ;;
  esac
  install -m644 $i .inst/contrib
done

for README in randomtrain ; do
  ln -s ../contrib/README.$README doc/README.$README
done

%files
%defattr(-,root,root)
%{_mandir}/man1/bogofilter.1.*
%{_mandir}/man1/bogolexer.1.*
%{_mandir}/man1/bogoutil.1.*
%{_mandir}/man1/bogoupgrade.1.*
%{_bindir}/bogofilter
%{_bindir}/bogolexer
%{_bindir}/bogoutil
%{_bindir}/bogoupgrade
%{_sysconfdir}/bogofilter.cf.example
%config(noreplace) %{_sysconfdir}/bogofilter.cf
%doc AUTHORS COPYING METHODS NEWS README TODO UPGRADE
%doc doc/README.Robinson
%doc doc/programmer
%doc .inst/contrib .inst/html .inst/xml

%changelog
