#!/bin/sh

pthreads_root=EXEC_PREFIX

includes='-I$pthreads_root/include'
libs='-lpthread -lm'

# Might be a good idea to also provide a way to override pthreads_root
# so that we can use this script in the build tree, before installation.
for arg in "$@" ; do
    case $arg in
	-nostdinc)	includes= ;;
	-nostdlib | -c)	libs= ;;
    esac
done

# Include the -L option in any case, just in case the user provided the
# names of some libraries we've built threaded versions of.
eval exec COMPILER '"$@"' $includes '-L$pthreads_root/lib' $libs
