/* Driver for routine fourn */

#include <stdio.h>
#include "complex.h"

#define NDIM 3
#define NDAT2 1024

void fourn(real[], unsigned long[], int, int);
float ran1(long *idum);

int main(void)
{
	int isign;
	long idum=(-23);
	unsigned long i,j,k,l,ndum=2,nn[NDIM];
	real data1[NDAT2],data2[NDAT2];

	for (i=1;i<=NDIM;i++) nn[i-1]=(ndum <<= 1);
	for (i=1;i<=nn[2];i++)
	  for (j=1;j<=nn[1];j++)
	    for (k=1;k<=nn[0];k++) {
	      l=k+(j-1)*nn[0]+(i-1)*nn[1]*nn[0];
	      l=(l<<1)-1;
	      /* real part of component */
	      data2[l-1]=data1[l-1]=2*ran1(&idum)-1;
	      /* imaginary part of component */
	      l++;
	      data2[l-1]=data1[l-1]=2*ran1(&idum)-1;
/*	      printf("%% %12.8f %12.8f\n",data2[l-2],data2[l-1]); */
	    }
	isign=1;
	fourn(data2,nn,NDIM,isign);
	/* here would be any processing to be done in Fourier space */
	isign = -1;
	fourn(data2,nn,NDIM,isign);
	printf("Double 3-dimensional transform\n\n");
	printf("%22s %24s %20s\n",
		"Double transf.","Original data","Ratio");
	printf("%10s %13s %12s %13s %11s %13s\n\n",
		"real","imag.","real","imag.","real","imag.");
	for (i=1;i<=nn[2];i++)
	  for (j=1;j<=nn[1];j++)
	    for (k=1;k<=nn[0];k++) {
	      l=k+(j-1)*nn[0]+(i-1)*nn[1]*nn[0];
	      l=(l<<1)-1;
	      printf("%9.2Lf %9.2Lf %9.2Lf %9.2Lf %17.10Le %17.10Le\n",
		     data2[l-1],data2[l],data1[l-1],data1[l],
		     (data2[l-1]/data1[l-1])-512,
		     (data2[l]/data1[l])-512);
	    }
	printf("\nThe product of transform lengths is: %4lu\n",nn[0]*nn[1]*nn[2]);
	return 0;
}
