function [r, gd, gdd] = stackgddfastmexwrap(ks, ds, n0, ns, dns, theta, pol)
% STACKGDDFASTMEXWRAP  Calculate complex reflection, group delay and GDD of
% arbitrary dielectric structure using approximate analytic methods,
% including only first order material dispersion. Assumes two indices.
% This software is provided as an example. This file is a wrapper which
% simply calls a MEX function, and allows for the same interface as
% the STACKGDDFAST M function.
%
% [r, gd, gdd] = stackgddfastmexwrap(ks, ds, n0, ns, dns, ddns, theta, pol)
%
% See the documenation for STACKGDDFAST for calling conventions.


if nargin > 5
  [r, gd, gdd] = stackgddfastmex(ks.', ds.', n0, ns.', dns.', theta, pol);
else
  [r, gd, gdd] = stackgddfastmex(ks.', ds.', n0, ns.', dns.');
end