#include "ps1/mapcc.h"
#include "ps1/char_stack.h"
#include "6170.h"
#include "ps1.h"

int main () {
    string InfileName;
    string OutfileName;
    string FnctfileName;
    int dir;
        
    cout << "Please enter a file for encode function:\n";
    cin >> FnctfileName;
    cout << "Please enter a file for output:\n";
    cin >> OutfileName;
    cout << "Please enter a file for input:\n";
    cin >> InfileName;
    cout << "Please enter direction of encryption:\n";
    cout << "0 for decryption, 1 for encryption\n";
    cin >> dir;
    
    crypt_file(FnctfileName, InfileName, OutfileName, dir);
}

void make_map(istream& i, mapcc* enc, mapcc* dec) {
    char ch, ch1, ch2, ch3;

//    Commented out to fit Problem 2 description.
//    check(i,"Input file doesn't exist");
//    check(enc, "Encryption map doesn't exist");
//    check(dec, "Decryption map doesn't exist");
    

    while(i.get(ch1) && i.get(ch2) && i.get(ch3)  && i.good()) {
//     Additional checks to make sure no duplicate entries in map
//     file exist.  Only relevant to Problem 1.
//	check(!enc->contains(ch1), "Map file has duplicate characters");
//	check(!dec->contains(ch1), "Map file has duplicate characters");
	enc->add(ch1, ch3);
	dec->add(ch3, ch1);

//    Flush rest of characters on line
	while((ch = i.get()) != '\n');
    }
}

void crypt (istream& i, ostream& o, mapcc* m) {
    char_stack *stack =  new char_stack();
    char ch;

//    Commented out to fit Problem 2 description
//    check(i, "Input file doesn't exist");
//    check(o, "Output file doesn't exist");
//    check(m, "Character map doesn't exist");
  
    while ((ch = i.get()) != EOF) {
	stack->push(ch);
    }
    
    while (!stack->empty()) {
	ch = stack->pop();
//    Again only relevant for Problem 1.
//	check(m->contains(ch), "Map doesn't contain match for character");
	ch = m->fetch(ch);
	o.put(ch);
    }    
}

void crypt_file(string fnct, string in, string out, bool dir) {
    ifstream fnctfile = input_file(fnct);
    ifstream infile  = input_file(in);
    ofstream outfile = overwrite_file(out);
    mapcc *encrypt_map = new mapcc();
    mapcc *decrypt_map = new mapcc();
    
    make_map(fnctfile, encrypt_map, decrypt_map);
    fnctfile.close(); 

    if (dir)
	crypt(infile, outfile, encrypt_map);
    else
	crypt(infile, outfile, decrypt_map);

    infile.close();
    outfile.close();
}

