/*
 *  ticker.c
 *
 *  a ticker is an object that returns the number of ticks
 *  since some fixed point in time.
 *
 *  a tick is defined as one-sixtieth of a second.
 *
 *  Mac has this built-in.  Windows has this built-in.
 *  Commodore 64 has this built-in.
 *
 *  Unix does not have this built-in.  Sigh.
 *
 *  Created by Salvatore Valente.
 *  No copyright.  Public domain.
 *
 */

#include <sys/time.h>
#include "ticker.h"

static long initial_seconds = 0;

void reset_tick_count (void)
{
     struct timeval tv;
     struct timezone tz;

     gettimeofday (&tv, &tz);
     initial_seconds = tv.tv_sec;
}

long get_tick_count (void)
{
     struct timeval tv;
     struct timezone tz;
     long ticks;

     if (gettimeofday (&tv, &tz) < 0)
	  return (-1);

     /* convert from seconds to ticks */
     ticks = ((tv.tv_sec - initial_seconds) * 60);
     /* convert from microseconds to ticks */
     ticks += (tv.tv_usec / (1000000 / 60));

     return (ticks);
}
