/*
 * StrataFlash driver for HTC Magician
 *
 * Copyright (C) 2006, Philipp Zabel
 *
 * This file is subject to the terms and conditions of the GNU General Public
 * License.  See the file COPYING in the main directory of this archive for
 * more details.
 */
#include <linux/module.h>
//#include <linux/dma-mapping.h>
#include <linux/mtd/mtd.h>
#include <linux/mtd/map.h>
#include <linux/mtd/partitions.h>
//#include <asm/mach-types.h>
#include <asm/io.h>
#include <asm/pgtable.h> // L_PTE_CACHEABLE
#include <asm/arch/pxa-regs.h> // PXA_CS0_PHYS

#include <linux/platform_device.h>
#include <asm/arch/magician.h> // MAGICIAN_EGPIO_NR
#include <asm/arch/magician_cpld.h> // magician_egpio_enable/disable

extern struct platform_device magician_cpld;

static void
magician_set_vpp(struct map_info *map, int vpp)
{
	static int old_vpp = 0;
	if (vpp == old_vpp)
		return;
	if (vpp)
		magician_egpio_enable(&magician_cpld, EGPIO_NR_MAGICIAN_FLASH_VPP);
	else
		magician_egpio_disable(&magician_cpld, EGPIO_NR_MAGICIAN_FLASH_VPP);
	old_vpp = vpp;
}

#define PXA_CS_SIZE		0x04000000

static struct map_info pxa272_map = {
	.name =      "pxa272-flash",
	.size =      PXA_CS_SIZE,
	.phys =      PXA_CS0_PHYS,
	.bankwidth = 4,
};

#ifdef CONFIG_MTD_PARTITIONS
static struct mtd_partition wince_partitions[] = {
	{
		name:		"bootloader",
		offset:		0,
		size:		1*0x40000,
		mask_flags:	MTD_WRITEABLE,  /* force read-only */
	},
	{
		name:		"osrom",
		size:		143*0x40000,
		mask_flags:	MTD_WRITEABLE,  /* force read-only */
		offset:		MTDPART_OFS_NXTBLK,
	},
	{
		name:		"backup_area",
		size:		32*0x40000,
		mask_flags:	MTD_WRITEABLE,  /* force read-only */
		offset:		MTDPART_OFS_NXTBLK,
	},
	{
		name:		"extrom",
		size:		76*0x40000,
		mask_flags:	MTD_WRITEABLE,  /* force read-only */
		offset:		MTDPART_OFS_NXTBLK,
	},
	{
		name:		"unused",
		size:		2*0x40000,
		mask_flags:	MTD_WRITEABLE,  /* force read-only */
		offset:		MTDPART_OFS_NXTBLK,
	},
	{
		name:		"splash",
		size:		1*0x40000,
		offset:		MTDPART_OFS_NXTBLK,
	},
	{
		name:		"asset",
		size:		1*0x40000,
		mask_flags:	MTD_WRITEABLE,  /* force read-only */
		offset:		MTDPART_OFS_NXTBLK,
	},
};
static struct mtd_partition *pxa272_parts;
#endif

static struct mtd_info *pxa272_mtd;

static int pxa272_flash_init (void)
{
	int mtd_parts, i;
	struct mtd_info *concat_mtd;
	struct map_info *map;
	char *part_type;
	int ret=0;

//	platform_set_drvdata(pdev, &hxflash);

	map = &pxa272_map;
	map->set_vpp = magician_set_vpp;
	//map->inval_cache = pxa272_flash_inval_cache;
	map->virt = ioremap_nocache(map->phys, PXA_CS_SIZE);
	if (!map->virt) {
		printk(KERN_ERR
			"Failed to ioremap %s\n", map->name);
		ret = -ENOMEM;
		goto probe_err;
	}
	map->cached = ioremap_cached(map->phys, PXA_CS_SIZE);
	if (!map->cached)
		printk(KERN_WARNING
			"Failed to ioremap cached %s\n", map->name);

	simple_map_init(map);
	printk(KERN_NOTICE
		"Probing %s at physical address 0x%08lx"
		" (%d-bit bankwidth)\n",
		map->name, map->phys, map->bankwidth * 8);

	pxa272_mtd = do_map_probe("cfi_probe", map);
	if (pxa272_mtd == NULL) {
	printk(KERN_NOTICE "pxa272 MTD failed to map flash.\n");
		ret = -ENXIO;
		goto probe_err;
	}
	pxa272_mtd->owner = THIS_MODULE;

#ifdef CONFIG_MTD_PARTITIONS
#if 0
	mtd_parts = parse_mtd_partitions(pxa272_mtd, probes,
			&parts, 0);
	if (mtd_parts > 0)
		part_type = "command line";
	else {
#endif
		part_type = "wince";
		pxa272_parts = wince_partitions;
		mtd_parts = ARRAY_SIZE(wince_partitions);
#if 0
	}
#endif

	printk(KERN_INFO "pxa272 MTD: using %s partition definitions\n",
		part_type);
	add_mtd_partitions(pxa272_mtd, pxa272_parts, mtd_parts);
#else
	add_mtd_device(pxa272_mtd);
#endif
	return 0;

probe_err:
	if (pxa272_map.virt)
		iounmap(pxa272_map.virt);
	if (pxa272_map.cached)
		iounmap(pxa272_map.cached);

	return ret;
}

static void pxa272_flash_exit (void)
{
	del_mtd_device(pxa272_mtd);

#ifdef CONFIG_MTD_PARTITIONS
	del_mtd_partitions(pxa272_mtd);
	//kfree(pxa272_parts);
#else
	del_mtd_device(pxa272_mtd);
#endif
	map_destroy(pxa272_mtd);
	iounmap(pxa272_map.virt);
	if (pxa272_map.cached)
		iounmap(pxa272_map.cached);

	return;
}

module_init (pxa272_flash_init);
module_exit (pxa272_flash_exit);

MODULE_AUTHOR("Philipp Zabel");
MODULE_DESCRIPTION("HTC Magician StrataFlash driver");
MODULE_LICENSE("GPL");
