# ARCH: Name of platform architecture
#   x86 -- Intel x86 architecture
#   sparc -- Sun SPARC
#   mips -- MIPS
ARCH    = unspecified

# THREADS: threads package
#   null -- No thread support
#   irix -- Irix 6.2 native thread support
#   scout -- Scout thread interface (on Linux)
#   sol -- Solaris 2.x native thread support
THREADS = null

# CC: C compiler for build and Toba use
CC = cc

# CBUILD: C flags for building C components of Toba runtime libraries
#  Common flags are:
#   -DOPTION_JIT -- Enable JIT compilation during runtime
#   -DNOTHREADS -- For THREADS=null
#   -DIRIX_THREADS -- For THREADS=irix
#   -DSCOUT_THREADS -- For THREADS=scout
#   -DSOLARIS_THREADS -- For THREADS=sol
#   -DBINARY_LOADER -- For platforms that support dynamic loading of
#         object files
CBUILD = -O

# CTOBA: C flags used by Toba when calling $CC
CTOBA = 

# GCCFLAGS: C flags used when building garbage collector
GCCFLAGS = -DJAVA_FINALIZATION -DALL_INTERIOR_POINTERS -DSILENT $(SYSGCCFLAGS)

# GCMF: Makefile to use in gc directory
GCMF = Makefile

# JAVA: JDK 1.0.2 interpreter
JAVA = java

# JAVAC: JDK 1.0.2 compiler/translator
JAVAC = javac

# TBUILD: Toba flags for building java components of Toba runtime
TBUILD = -O

# RTLIBS: libraries for linking Toba programs
RTLIBS = -lm

# SLOPT: ld option for creating a shared library
SLOPT = -shared

# RPOPT: $CC option prefix for embedding a shared library path
RPOPT = "-rpath "

# LTARG:Library make targets
LTARG = shared

# LIBS: Extra libraries to be added in all links of tobafied executables
LIBS =

# RTLDFLAGS: Additional object files and flags passed when building runtime package
RTLDFLAGS=

# GRCFLAGS: Extra C flags to be added when compiling graphical programs
GRCFLAGS =

# GRLDFLAGS: Extra libraries to be added when linking graphical programs
GRLDFLAGS =

# PROC: Process source files.  Set to one of $(WINPROC) $(UNIXPROC)
WINPROC = lang_Win32Process.c
UNIXPROC = lang_UNIXProcess.c lang_ProcessReaper.c
PROC = $(UNIXPROC)

# SUFFIX: Suffix appended to executables by the linker (e.g. ".exe")
SUFFIX =

# BOOTSTRAP: Used for remote execution if bootstrapping is needed
BOOTSTRAP =

# TobaPackage: When building the jit, we need a TOBA package that contains
#  classfile, jit, and runtime support.  Set it to TobaPackage in that case;
#  otherwise leave it blank
#TobaPackage = TobaPackage
TobaPackage = 

# JIT_TARGET: Makefile goal for things that are built differently with
#   or without the jit.  Set to withjit if you have -DOPTION_JIT in
#   CBUILD; leave as nojit otherwise.
#JIT_TARGET = withjit
JIT_TARGET = nojit
