#include <fcntl.h>
#include <errno.h>
#include <sys/types.h>
#include <unistd.h>

#include "toba.h"
#include "runtime.h"
#include "java_io_FileInputStream.h"

/* java/io/FileInputStream open (Ljava/lang/String;)V */
Void open_S_xlEGg(Object Harg1, Object name) 
{
    struct in_java_io_FileInputStream *this = 
        (struct in_java_io_FileInputStream *)Harg1;

    fd_open(this->fd, name, O_RDONLY);
}

/* java/io/FileInputStream read ()I */
Int read__4UFtx(Object Harg1) 
{
    struct in_java_io_FileInputStream *this = 
        (struct in_java_io_FileInputStream *)Harg1;

    return fd_read_char(this->fd);
}

/* java/io/FileInputStream readBytes ([BII)I */
Int readBytes_abii_cff29(Object Harg1, Object buf, Int off, Int len) 
{
    struct in_java_io_FileInputStream *this = 
        (struct in_java_io_FileInputStream *)Harg1;

    return fd_read_bytes(this->fd, buf, off, len);
}

/* java/io/FileInputStream skip (J)J */
Long skip_l_qkZM8(Object Harg1, Long count) 
{
    struct in_java_io_FileInputStream *this = 
        (struct in_java_io_FileInputStream *)Harg1;
    struct in_java_io_FileDescriptor *fd;
    Long res;

    fd = this->fd;
    if(!fd)
        throwNullPointerException("skip");

    res = lseek(unix_fd(fd->fd), (off_t)count, SEEK_CUR);
    if(res == -1)
        throwIOException("seek", errno);

    return res;
}

/* java/io/FileInputStream available ()I */
Int available__FyZ08(Object Harg1) 
{
    struct in_java_io_FileInputStream *this = 
        (struct in_java_io_FileInputStream *)Harg1;
    struct in_java_io_FileDescriptor *fd;
    int res;

    off_t pos, length;

    fd = this->fd;
    if(!fd)
        throwNullPointerException("available");

    if((pos = lseek(unix_fd(fd->fd), (off_t)0, SEEK_CUR)) == -1 ||
       (length = lseek(unix_fd(fd->fd), (off_t)0, SEEK_END)) == -1 ||
       lseek(unix_fd(fd->fd), (off_t)pos, SEEK_SET) == -1)
        throwIOException("lseek", errno);
    res = length - pos;

    return res;
}

/* java/io/FileInputStream close ()V */
Void close__NPlAp(Object Harg1) 
{
    struct in_java_io_FileInputStream *this = 
        (struct in_java_io_FileInputStream *)Harg1;

    fd_close(this->fd);
}

