#include <fcntl.h>
#include <sys/types.h>
#include <unistd.h>
#include <errno.h>

#include "toba.h"
#include "runtime.h"
#include "java_io_RandomAccessFile.h"
#include "java_io_FileDescriptor.h"

/* java/io/RandomAccessFile open (Ljava/lang/String;Z)V */
Void open_Sz_QZMn4(Object Harg1, Object name, Boolean wr) 
{
    struct in_java_io_RandomAccessFile *this = 
        (struct in_java_io_RandomAccessFile *)Harg1;

    if(wr == JAVA_TRUE)
        fd_open(this->fd, name, O_RDWR | O_CREAT);
    else
        fd_open(this->fd, name, O_RDONLY);
}

/* java/io/RandomAccessFile read ()I */
Int read__V4hc6(Object Harg1) 
{
    struct in_java_io_RandomAccessFile *this = 
        (struct in_java_io_RandomAccessFile *)Harg1;

    return fd_read_char(this->fd);
}

/* java/io/RandomAccessFile readBytes ([BII)I */
Int readBytes_abii_PqyyW(Object Harg1, Object buf, Int off, Int len) 
{
    struct in_java_io_RandomAccessFile *this = 
        (struct in_java_io_RandomAccessFile *)Harg1;

    return fd_read_bytes(this->fd, buf, off, len);
}

/* java/io/RandomAccessFile write (I)V */
Void write_i_uaD3q(Object Harg1, Int ch) 
{
    struct in_java_io_RandomAccessFile *this = 
        (struct in_java_io_RandomAccessFile *)Harg1;

    fd_write_char(this->fd, ch);
}

/* java/io/RandomAccessFile writeBytes ([BII)V */
Void writeBytes_abii_933Ek(Object Harg1, Object buf, Int off, Int len) 
{
    struct in_java_io_RandomAccessFile *this = 
        (struct in_java_io_RandomAccessFile *)Harg1;

    fd_write_bytes(this->fd, buf, off, len);
}

/* java/io/RandomAccessFile getFilePointer ()J */
Long getFilePointer__ZNZHm(Object Harg1) 
{
    struct in_java_io_RandomAccessFile *this = 
        (struct in_java_io_RandomAccessFile *)Harg1;
    struct in_java_io_FileDescriptor *fd;
    off_t pos;

    fd = this->fd;
    if(!fd)
        throwNullPointerException("getFilePointer");

    pos = lseek(unix_fd(fd->fd), (off_t)0, SEEK_CUR);
    if(pos == -1)
        throwIOException("lseek", errno);

    return pos;
}

/* java/io/RandomAccessFile seek (J)V */
Void seek_l_ap1IS(Object Harg1, Long pos) 
{
    struct in_java_io_RandomAccessFile *this = 
        (struct in_java_io_RandomAccessFile *)Harg1;
    struct in_java_io_FileDescriptor *fd;
    off_t res;

    fd = this->fd;
    if(!fd)
        throwNullPointerException("seek");

    res = lseek(unix_fd(fd->fd), (off_t)pos, SEEK_SET);
    if(res == -1)
        throwIOException("lseek", errno);
}

/* java/io/RandomAccessFile length ()J */
Long length__gq6Pd(Object Harg1) 
{
    struct in_java_io_RandomAccessFile *this = 
        (struct in_java_io_RandomAccessFile *)Harg1;
    struct in_java_io_FileDescriptor *fd;
    off_t pos, length;

    fd = this->fd;
    if(!fd)
        throwNullPointerException("length");

    if((pos = lseek(unix_fd(fd->fd), (off_t)0, SEEK_CUR)) == -1 ||
       (length = lseek(unix_fd(fd->fd), (off_t)0, SEEK_END)) == -1 ||
       lseek(unix_fd(fd->fd), (off_t)pos, SEEK_SET) == -1)
        throwIOException("lseek", errno);

    return length;
}

/* java/io/RandomAccessFile close ()V */
Void close__w2IKV(Object Harg1) 
{
    struct in_java_io_RandomAccessFile *this = 
        (struct in_java_io_RandomAccessFile *)Harg1;

    fd_close(this->fd);
}

