/* $Id: jit_CodeBlock.c,v 1.6 1998/02/27 16:39:41 pab Exp $
 * Created: Sat Jun 21 13:41:05 1997
 * Peter A. Bigot (pab@localhost.localdomain)
 *
 * Description: 
 * Native code support for toba.jit.CodeBlock class, which is used to build
 * up code blocks on-the-fly during just-in-time compilation.
 */

/* ------------- */
/* Include Files */

#include <stdio.h>              /* Standard input/output routines */
#include <stdlib.h>             /* Standard library routines */
#include <assert.h>             /* Debugging assertion macro */

#include "toba.h"               /* Basic Toba declarations */
#include "runtime.h"
#include "md.h"                 /* Add prototypes for things like addressToLong */

/* ------------------------------- */
/* Constant and Macro Declarations */

/* ----------------- */
/* Type Declarations */

/* -------------------- */
/* Variable Definitions */

/* -------------------- */
/* Function Definitions */

static void *longToAddress(Long l)
{
    return (void *)(long)l;
}
static Long addressToLong(void *v)
{
    return (Long)(long)v;
}

/* Allocate a block of memory that is nArr bytes long, to hold native
 * code. */
Long
allocNativeBlock_i_eyDZd (int nArr)
{
   unsigned char * bp;          /* Allocated block of code */

   bp = allocate (nArr * sizeof (unsigned char));
   return addressToLong (bp);
}

/* Copy the data from a Java array of integers into the provided block,
 * which must have been allocated and be big enough. */
void
copyNativeCode_abil_J4do9 (Object ao,     /* Source array of data */
                           int ncb,       /* Number of bytes to copy */
                           Long natfp)    /* Where to store data */
{
   struct barray * ba = (struct barray *) ao; /* Array of bytes: data */
   int * fp = longToAddress (natfp); /* Where to store data */

   memcpy (fp, ba->data, ncb * sizeof (unsigned char));
   return;
}

