#include <stdlib.h>
#include <stdio.h>
#include "toba.h"
#include "runtime.h"
#include "java_lang_Double.h"

#ifdef SCOUT
/* scout currently doesn't have this, but we need a prototype to avoid
 * warnings.  It's stubbed out. */
double strtod (const char * nptr, char ** endptr);
#endif /* SCOUT */

/* java/lang/Double toString (D)Ljava/lang/String; */
Object toString_d_wYd4B(Double arg1) 
{
    char buf[20];

    /* STATIC Method */
    init_java_lang_Double();

    sprintf(buf, "%g", arg1);
    return javastring(buf);
}

/* java/lang/Double valueOf (Ljava/lang/String;)Ljava/lang/Double; */
Object valueOf_S_gYdTN(Object Harg1) 
{
    struct in_java_lang_String *arg1 = (struct in_java_lang_String *)Harg1;
    struct in_java_lang_Double *ret;
    Double retval;
    char *str, *strend;

    /* STATIC Method */
    init_java_lang_Double();

    if(!arg1)
        throwNullPointerException("valueOf");

    str = cstring(arg1);
    retval = strtod(str, &strend);
    if(strend == str) 
        throwNumberFormatException(str);

    ret = new(&cl_java_lang_Double.C);
    init_d_aASAU(ret, retval);
    return ret;
}

/* java/lang/Double doubleToLongBits (D)J */
Long doubleToLongBits_d_Y4dyM(Double arg1) 
{
    Long *retp = (Long *)&arg1;

    /* STATIC Method */
    init_java_lang_Double();

    return *retp;
}

/* java/lang/Double longBitsToDouble (J)D */
Double longBitsToDouble_l_SRfM6(Long arg1) 
{
    Double *retp = (Double *)&arg1;

    /* STATIC Method */
    init_java_lang_Double();

    return *retp;
}

